/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheBuilder;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserExecutor;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLStatementParserEngine {
    private final SQLStatementParserExecutor sqlStatementParserExecutor;
    private final LoadingCache<String, SQLStatement> sqlStatementCache;
    private final CacheOption sqlStatementCacheOption;
    private final CacheOption parseTreeCacheOption;

    public SQLStatementParserEngine(DatabaseType databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption) {
        this.sqlStatementParserExecutor = new SQLStatementParserExecutor(databaseType, parseTreeCacheOption);
        this.sqlStatementCache = SQLStatementCacheBuilder.build(databaseType, sqlStatementCacheOption, parseTreeCacheOption);
        this.sqlStatementCacheOption = sqlStatementCacheOption;
        this.parseTreeCacheOption = parseTreeCacheOption;
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return useCache ? (SQLStatement)this.sqlStatementCache.get((Object)sql) : this.sqlStatementParserExecutor.parse(sql);
    }

    @Generated
    public CacheOption getSqlStatementCacheOption() {
        return this.sqlStatementCacheOption;
    }

    @Generated
    public CacheOption getParseTreeCacheOption() {
        return this.parseTreeCacheOption;
    }
}

