/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class EncryptInsertValueParameterRewriter
implements ParameterRewriter {
    private final EncryptRule rule;
    private final String databaseName;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatementContext)sqlStatementContext).getSqlStatement().getSetAssignment().isPresent() && null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        InsertStatementContext insertStatementContext = (InsertStatementContext)sqlStatementContext;
        String tableName = insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(tableName);
        if (!encryptTable.isPresent()) {
            return;
        }
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(insertStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!this.rule.findEncryptTable(tableName).map(optional -> optional.isEncryptColumn(columnName)).orElse(false).booleanValue()) continue;
            this.encryptInsertValues((GroupedParameterBuilder)paramBuilder, insertStatementContext, schemaName, tableName, columnName);
        }
    }

    private void encryptInsertValues(GroupedParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, String schemaName, String tableName, String columnName) {
        EncryptColumn encryptColumn = this.rule.getEncryptTable(tableName).getEncryptColumn(columnName);
        int columnIndex = this.getColumnIndex(paramBuilder, insertStatementContext, columnName);
        int count = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            int paramIndex = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getParameterIndex(columnIndex);
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParamBuilder = (StandardParameterBuilder)paramBuilder.getParameterBuilders().get(count);
                ExpressionSegment expressionSegment = (ExpressionSegment)((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValueExpressions().get(columnIndex);
                if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                    Object literalValue = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getLiteralValue(columnIndex).orElse(null);
                    this.encryptInsertValue(encryptColumn, paramIndex, literalValue, standardParamBuilder, schemaName, tableName);
                }
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, String encryptLogicColumnName) {
        ArrayList columnNames;
        if (paramBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(insertStatementContext.getColumnNames());
            columnNames.remove(paramBuilder.getDerivedColumnName().get());
        } else {
            columnNames = insertStatementContext.getColumnNames();
        }
        return columnNames.indexOf(encryptLogicColumnName);
    }

    private void encryptInsertValue(EncryptColumn encryptColumn, int paramIndex, Object originalValue, StandardParameterBuilder paramBuilder, String schemaName, String tableName) {
        String columnName = encryptColumn.getName();
        paramBuilder.addReplacedParameters(paramIndex, encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, originalValue));
        LinkedList<Object> addedParams = new LinkedList<Object>();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            addedParams.add(encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValue));
        }
        if (encryptColumn.getLikeQuery().isPresent()) {
            addedParams.add(encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValue));
        }
        if (!addedParams.isEmpty()) {
            if (!paramBuilder.getAddedIndexAndParameters().containsKey(paramIndex)) {
                paramBuilder.getAddedIndexAndParameters().put(paramIndex, new LinkedList());
            }
            ((Collection)paramBuilder.getAddedIndexAndParameters().get(paramIndex)).addAll(addedParams);
        }
    }

    @Generated
    public EncryptInsertValueParameterRewriter(EncryptRule rule, String databaseName) {
        this.rule = rule;
        this.databaseName = databaseName;
    }
}

