/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.predicate;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingMatchedEncryptQueryAlgorithmException;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.JoinConditionsEncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class EncryptPredicateColumnSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        Collection allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts((SQLStatementContext)sqlStatementContext);
        Collection joinConditions = SQLStatementContextExtractor.getJoinConditions((WhereAvailable)((WhereAvailable)sqlStatementContext), (Collection)allSubqueryContexts);
        ShardingSpherePreconditions.checkState((boolean)JoinConditionsEncryptorComparator.isSame(joinConditions, rule), () -> new UnsupportedSQLOperationException("Can not use different encryptor in join condition"));
        this.check(rule, (WhereAvailable)sqlStatementContext);
    }

    private void check(EncryptRule rule, WhereAvailable sqlStatementContext) {
        for (ColumnSegment each : sqlStatementContext.getColumnSegments()) {
            Optional<EncryptTable> encryptTable = rule.findEncryptTable(each.getColumnBoundInfo().getOriginalTable().getValue());
            String columnName = each.getIdentifier().getValue();
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName) || !this.includesLike(sqlStatementContext.getWhereSegments(), each)) continue;
            String tableName = encryptTable.get().getTable();
            ShardingSpherePreconditions.checkState((boolean)encryptTable.get().getEncryptColumn(columnName).getLikeQuery().isPresent(), () -> new MissingMatchedEncryptQueryAlgorithmException(tableName, columnName, "LIKE"));
        }
    }

    private boolean includesLike(Collection<WhereSegment> whereSegments, ColumnSegment targetColumnSegment) {
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractor.extractAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate andPredicate : andPredicates) {
                if (!this.isLikeColumnSegment(andPredicate, targetColumnSegment)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLikeColumnSegment(AndPredicate andPredicate, ColumnSegment targetColumnSegment) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            if (!(each instanceof BinaryOperationExpression) || !"LIKE".equalsIgnoreCase(((BinaryOperationExpression)each).getOperator()) || !this.isSameColumnSegment(((BinaryOperationExpression)each).getLeft(), targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumnSegment(ExpressionSegment columnSegment, ColumnSegment targetColumnSegment) {
        return columnSegment instanceof ColumnSegment && columnSegment.getStartIndex() == targetColumnSegment.getStartIndex() && columnSegment.getStopIndex() == targetColumnSegment.getStopIndex();
    }
}

