/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.checker.ActiveVersionChecker;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.metadata.TableMetaDataNodePath;

public final class TableChangedHandler {
    private final ContextManager contextManager;
    private final ShardingSphereStatisticsRefreshEngine statisticsRefreshEngine;

    public TableChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new ShardingSphereStatisticsRefreshEngine(contextManager);
    }

    public void handleCreatedOrAltered(String databaseName, String schemaName, DataChangedEvent event) {
        String tableName = (String)TableMetaDataNodePath.getTableNameByActiveVersionPath((String)event.getKey()).orElseThrow(() -> new IllegalStateException("Table name not found."));
        ActiveVersionChecker.checkActiveVersion(this.contextManager, event);
        ShardingSphereTable table = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDatabaseMetaDataFacade().getTable().load(databaseName, schemaName, tableName);
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(databaseName, schemaName, table, null);
        this.statisticsRefreshEngine.asyncRefresh();
    }

    public void handleDropped(String databaseName, String schemaName, DataChangedEvent event) {
        String tableName = (String)TableMetaDataNodePath.findTableName((String)event.getKey()).orElseThrow(() -> new IllegalStateException("Table name not found."));
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().alterSchema(databaseName, schemaName, tableName, null);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

