/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.connector.url;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;

public final class JdbcUrlAppender {
    public String appendQueryProperties(String jdbcUrl, Properties queryProps) {
        if (queryProps.isEmpty()) {
            return jdbcUrl;
        }
        Properties currentQueryProps = DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, DatabaseTypeFactory.get(jdbcUrl)).parse(jdbcUrl, null, null).getQueryProperties();
        return this.hasConflictedQueryProperties(currentQueryProps, queryProps) ? jdbcUrl.substring(0, jdbcUrl.indexOf(63) + 1) + this.concat(this.getMergedProperties(currentQueryProps, queryProps)) : jdbcUrl + this.getURLDelimiter(currentQueryProps) + this.concat(queryProps);
    }

    private boolean hasConflictedQueryProperties(Properties currentQueryProps, Properties toBeAppendedQueryProps) {
        return toBeAppendedQueryProps.keySet().stream().anyMatch(currentQueryProps::containsKey);
    }

    private Properties getMergedProperties(Properties currentQueryProps, Properties toBeAppendedQueryProps) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)currentQueryProps);
        result.putAll((Map<?, ?>)toBeAppendedQueryProps);
        return result;
    }

    private String getURLDelimiter(Properties currentQueryProps) {
        return currentQueryProps.isEmpty() ? "?" : "&";
    }

    private String concat(Properties queryProps) {
        return queryProps.entrySet().stream().map(entry -> String.join((CharSequence)"=", entry.getKey().toString(), entry.getValue().toString())).collect(Collectors.joining("&"));
    }
}

