/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.node.tuple.annotation.RepositoryTupleEntity;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalConfigurationManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationManager.class);
    private final MetaDataContexts metaDataContexts;
    private final MetaDataPersistService metaDataPersistService;

    public GlobalConfigurationManager(MetaDataContexts metaDataContexts, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void alterGlobalRuleConfiguration(RuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return;
        }
        this.closeStaleTransactionRule(ruleConfig);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules());
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        rules.addAll(GlobalRulesBuilder.buildSingleRules((RuleConfiguration)ruleConfig, (Collection)this.metaDataContexts.getMetaData().getAllDatabases(), (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps()));
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().clear();
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().addAll(rules);
        this.metaDataContexts.update(new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps()), this.metaDataPersistService);
    }

    private void closeStaleTransactionRule(RuleConfiguration ruleConfig) {
        YamlRuleConfiguration yamlRuleConfig = new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfiguration(ruleConfig);
        if (!"transaction".equals(Objects.requireNonNull(yamlRuleConfig.getClass().getAnnotation(RepositoryTupleEntity.class)).value())) {
            return;
        }
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(TransactionRule.class).ifPresent(TransactionRule::close);
    }

    public synchronized void alterProperties(Properties props) {
        this.metaDataContexts.update(new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), new ConfigurationProperties(props)), this.metaDataPersistService);
    }
}

