/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetRecordMaterializer;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\n\u0014\u0001\tB\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\t{\u0001\u0011\t\u0011)A\u0005_!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!i\u0006A!A!\u0002\u0013\u0019\u0005\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b)\u0004A\u0011A6\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0013\u0019\b\"\u0003>\u0001\u0001\u0004\u0005\r\u0011\"\u0003|\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006K\u0001\u001e\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\tI\u0004\u0001C!\u0003w9q!!#\u0014\u0011\u0003\tYI\u0002\u0004\u0013'!\u0005\u0011Q\u0012\u0005\u0007U:!\t!!&\t\u000f\u0005]e\u0002\"\u0003\u0002\u001a\"9\u00111\u0016\b\u0005\u0002\u00055&!F$f_B\u000b'/];fiJ+\u0017\rZ*vaB|'\u000f\u001e\u0006\u0003)U\tq\u0001]1scV,GO\u0003\u0002\u0017/\u0005YA-\u0019;bg>,(oY3t\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u0014\u0011\u0005\u0011*S\"A\n\n\u0005\u0019\u001a\"A\u0005)beF,X\r\u001e*fC\u0012\u001cV\u000f\u001d9peR\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000e\u0002\u0011%tG/\u001a:oC2L!\u0001L\u0015\u0003\u000f1{wmZ5oO\u0006I1m\u001c8wKJ$HK_\u000b\u0002_A\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012aa\u00149uS>t\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011!\u0018.\\3\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u00075>tW-\u00133\u0002\u0015\r|gN^3siRS\b%\u0001\ff]\u0006\u0014G.\u001a,fGR|'/\u001b>fIJ+\u0017\rZ3s!\t\u0001\u0004)\u0003\u0002Bc\t9!i\\8mK\u0006t\u0017A\u00053bi\u0016$\u0018.\\3SK\n\f7/Z'pI\u0016\u0004\"\u0001R-\u000f\u0005\u00153fB\u0001$T\u001d\t9%K\u0004\u0002I#:\u0011\u0011\n\u0015\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!T\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\taR$\u0003\u0002\u001b7%\u0011!&G\u0005\u0003)V\u000bqaU)M\u0007>tgM\u0003\u0002+3%\u0011q\u000bW\u0001\u0015\u0019\u0016<\u0017mY=CK\"\fg/[8s!>d\u0017nY=\u000b\u0005Q+\u0016B\u0001.\\\u0005\u00151\u0016\r\\;f\u0013\ta\u0016GA\u0006F]VlWM]1uS>t\u0017aD5oif2$+\u001a2bg\u0016lu\u000eZ3\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003aI\u001e<gBA1c!\tY\u0015'\u0003\u0002dc\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\u00075\u000b\u0007O\u0003\u0002dcA\u0011\u0001\r[\u0005\u0003S\u001a\u0014aa\u0015;sS:<\u0017A\u0002\u001fj]&$h\b\u0006\u0004m[:|\u0007/\u001d\t\u0003I\u0001AQ!L\u0004A\u0002=BQAP\u0004A\u0002}BQAQ\u0004A\u0002\rCQ!X\u0004A\u0002\rCQAX\u0004A\u0002}\u000bqcY1uC2L8\u000f\u001e*fcV,7\u000f^3e'\u000eDW-\\1\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a^\r\u0002\u000bQL\b/Z:\n\u0005e4(AC*ueV\u001cG\u000fV=qK\u0006Y2-\u0019;bYf\u001cHOU3rk\u0016\u001cH/\u001a3TG\",W.Y0%KF$\"\u0001`@\u0011\u0005Aj\u0018B\u0001@2\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u0011\"!AA\u0002Q\f1\u0001\u001f\u00132\u0003a\u0019\u0017\r^1msN$(+Z9vKN$X\rZ*dQ\u0016l\u0017\rI\u0001\u0005S:LG\u000f\u0006\u0003\u0002\n\u00055\u0002\u0003BA\u0006\u0003OqA!!\u0004\u0002\"9!\u0011qBA\u000e\u001d\u0011\t\t\"!\u0006\u000f\u0007%\u000b\u0019\"\u0003\u0002\u0015;%!\u0011qCA\r\u0003\u0019A\u0017\rZ8pa*\u0011A#H\u0005\u0005\u0003;\ty\"A\u0002ba&TA!a\u0006\u0002\u001a%!\u00111EA\u0013\u0003-\u0011V-\u00193TkB\u0004xN\u001d;\u000b\t\u0005u\u0011qD\u0005\u0005\u0003S\tYCA\u0006SK\u0006$7i\u001c8uKb$(\u0002BA\u0012\u0003KAq!a\f\f\u0001\u0004\t\t$A\u0004d_:$X\r\u001f;\u0011\t\u0005M\u0012QG\u0007\u0003\u0003KIA!a\u000e\u0002&\tY\u0011J\\5u\u0007>tG/\u001a=u\u00039\u0001(/\u001a9be\u00164uN\u001d*fC\u0012$\"\"!\u0010\u0002X\u0005\u001d\u0014QOAC!\u0019\ty$a\u0012\u0002L5\u0011\u0011\u0011\t\u0006\u0005\u0003;\t\u0019E\u0003\u0003\u0002F\u0005e\u0011AA5p\u0013\u0011\tI%!\u0011\u0003%I+7m\u001c:e\u001b\u0006$XM]5bY&TXM\u001d\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K\r\u0002\u0011\r\fG/\u00197zgRLA!!\u0016\u0002P\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\tI\u0006\u0004a\u0001\u00037\nAaY8oMB!\u0011QLA2\u001b\t\tyF\u0003\u0003\u0002Z\u0005\u0005$bAA\f;%!\u0011QMA0\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011\u0011\u000e\u0007A\u0002\u0005-\u0014\u0001E6fsZ\u000bG.^3NKR\fG)\u0019;b!\u0019\ti'a\u001dhO6\u0011\u0011q\u000e\u0006\u0004\u0003cJ\u0014\u0001B;uS2L1!ZA8\u0011\u001d\t9\b\u0004a\u0001\u0003s\n!BZ5mKN\u001b\u0007.Z7b!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u00033\taa]2iK6\f\u0017\u0002BAB\u0003{\u00121\"T3tg\u0006<W\rV=qK\"9\u0011q\u0011\u0007A\u0002\u0005%\u0011a\u0003:fC\u0012\u001cuN\u001c;fqR\fQcR3p!\u0006\u0014\u0018/^3u%\u0016\fGmU;qa>\u0014H\u000f\u0005\u0002%\u001dM!a\"a$(!\r\u0001\u0014\u0011S\u0005\u0004\u0003'\u000b$AB!osJ+g\r\u0006\u0002\u0002\f\u00061\u0012N\u001c;feN,7\r\u001e)beF,X\r^$s_V\u00048\u000f\u0006\u0004\u0002\u001c\u0006\r\u0016q\u0015\t\u0005aM\ni\n\u0005\u0003\u0002|\u0005}\u0015\u0002BAQ\u0003{\u0012\u0011b\u0012:pkB$\u0016\u0010]3\t\u000f\u0005\u0015\u0006\u00031\u0001\u0002\u001e\u0006QqM]8vaRK\b/Z\u0019\t\u000f\u0005%\u0006\u00031\u0001\u0002\u001e\u0006QqM]8vaRK\b/\u001a\u001a\u0002\u0013\u0015D\b/\u00198e+\u0012#Fc\u0001;\u00020\"1\u0011qP\tA\u0002Q\u0004")
public class GeoParquetReadSupport
extends ParquetReadSupport {
    private final Option<ZoneId> convertTz;
    private final boolean enableVectorizedReader;
    private final Enumeration.Value datetimeRebaseMode;
    private final Enumeration.Value int96RebaseMode;
    private final scala.collection.immutable.Map<String, String> parameters;
    private StructType catalystRequestedSchema;

    public static StructType expandUDT(StructType schema) {
        return GeoParquetReadSupport$.MODULE$.expandUDT(schema);
    }

    public Option<ZoneId> convertTz() {
        return this.convertTz;
    }

    private StructType catalystRequestedSchema() {
        return this.catalystRequestedSchema;
    }

    private void catalystRequestedSchema_$eq(StructType x$1) {
        this.catalystRequestedSchema = x$1;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        Configuration conf = context.getConfiguration();
        String schemaString = conf.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        Predef$.MODULE$.assert(schemaString != null, (Function0 & Serializable)() -> "Parquet requested schema not set.");
        this.catalystRequestedSchema_$eq(StructType$.MODULE$.fromString(schemaString));
        boolean caseSensitive = conf.getBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.CASE_SENSITIVE().defaultValue().get()));
        boolean schemaPruningEnabled = conf.getBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().defaultValue().get()));
        boolean useFieldId = conf.getBoolean(SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().defaultValue().get()));
        MessageType parquetFileSchema = context.getFileSchema();
        MessageType parquetClippedSchema = ParquetReadSupport$.MODULE$.clipParquetSchema(parquetFileSchema, this.catalystRequestedSchema(), caseSensitive, useFieldId);
        MessageType parquetRequestedSchema = schemaPruningEnabled && !this.enableVectorizedReader ? (MessageType)GeoParquetReadSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetReadSupport$$intersectParquetGroups((GroupType)parquetClippedSchema, (GroupType)parquetFileSchema).map((Function1 & Serializable)groupType -> new MessageType(groupType.getName(), groupType.getFields())).getOrElse((Function0 & Serializable)() -> ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE()) : parquetClippedSchema;
        this.logDebug((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(273).append("Going to read the following fields from the Parquet file with the following schema:\n         |Parquet file schema:\n         |").append(parquetFileSchema).append("\n         |Parquet clipped schema:\n         |").append(parquetClippedSchema).append("\n         |Parquet requested schema:\n         |").append(parquetRequestedSchema).append("\n         |Catalyst requested schema:\n         |").append(this.catalystRequestedSchema().treeString()).append("\n       ").toString())));
        return new ReadSupport.ReadContext(parquetRequestedSchema, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
    }

    public RecordMaterializer<InternalRow> prepareForRead(Configuration conf, java.util.Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType parquetRequestedSchema = readContext.getRequestedSchema();
        return new GeoParquetRecordMaterializer(parquetRequestedSchema, GeoParquetReadSupport$.MODULE$.expandUDT(this.catalystRequestedSchema()), new GeoParquetToSparkSchemaConverter(keyValueMetaData, conf, this.parameters), this.convertTz(), this.datetimeRebaseMode, this.int96RebaseMode, this.parameters);
    }

    public GeoParquetReadSupport(Option<ZoneId> convertTz, boolean enableVectorizedReader, Enumeration.Value datetimeRebaseMode, Enumeration.Value int96RebaseMode, scala.collection.immutable.Map<String, String> parameters) {
        this.convertTz = convertTz;
        this.enableVectorizedReader = enableVectorizedReader;
        this.datetimeRebaseMode = datetimeRebaseMode;
        this.int96RebaseMode = int96RebaseMode;
        this.parameters = parameters;
    }
}

