/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.Platform;
import com.google.common.geometry.S2;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp final class S1Interval
implements Cloneable,
Serializable {
    private double lo;
    private double hi;

    public S1Interval() {
        this.setEmpty();
    }

    public S1Interval(double lo, double hi) {
        this(lo, hi, false);
    }

    public S1Interval(S1Interval interval) {
        this.lo = interval.lo;
        this.hi = interval.hi;
    }

    private S1Interval(double lo, double hi, boolean checked) {
        this.set(lo, hi, checked);
    }

    void set(double newLo, double newHi, boolean checked) {
        this.lo = newLo;
        this.hi = newHi;
        if (!checked) {
            if (newLo == -Math.PI && newHi != Math.PI) {
                this.lo = Math.PI;
            }
            if (newHi == -Math.PI && newLo != Math.PI) {
                this.hi = Math.PI;
            }
        }
    }

    void setEmpty() {
        this.lo = Math.PI;
        this.hi = -Math.PI;
    }

    void setFull() {
        this.lo = -Math.PI;
        this.hi = Math.PI;
    }

    public static S1Interval empty() {
        S1Interval result = new S1Interval();
        result.setEmpty();
        return result;
    }

    public static S1Interval full() {
        S1Interval result = new S1Interval();
        result.setFull();
        return result;
    }

    public static S1Interval fromPoint(double radians2) {
        if (radians2 == -Math.PI) {
            radians2 = Math.PI;
        }
        return new S1Interval(radians2, radians2, true);
    }

    public static S1Interval fromPointPair(double p1, double p2) {
        S1Interval result = new S1Interval();
        result.initFromPointPair(p1, p2);
        return result;
    }

    void initFromPointPair(double p1, double p2) {
        if (p1 == -Math.PI) {
            p1 = Math.PI;
        }
        if (p2 == -Math.PI) {
            p2 = Math.PI;
        }
        if (S1Interval.positiveDistance(p1, p2) <= Math.PI) {
            this.lo = p1;
            this.hi = p2;
        } else {
            this.lo = p2;
            this.hi = p1;
        }
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean isValid() {
        return Math.abs(this.lo) <= Math.PI && Math.abs(this.hi) <= Math.PI && (this.lo != -Math.PI || this.hi == Math.PI) && (this.hi != -Math.PI || this.lo == Math.PI);
    }

    public boolean isFull() {
        return this.hi - this.lo == Math.PI * 2;
    }

    public boolean isEmpty() {
        return this.lo - this.hi == Math.PI * 2;
    }

    public boolean isInverted() {
        return this.lo > this.hi;
    }

    public double getCenter() {
        double center = 0.5 * (this.lo + this.hi);
        if (!this.isInverted()) {
            return center;
        }
        return center <= 0.0 ? center + Math.PI : center - Math.PI;
    }

    public double getLength() {
        double length = this.hi - this.lo;
        if (length >= 0.0) {
            return length;
        }
        return (length += Math.PI * 2) > 0.0 ? length : -1.0;
    }

    public S1Interval complement() {
        if (this.lo == this.hi) {
            return S1Interval.full();
        }
        return new S1Interval(this.hi, this.lo, true);
    }

    public double getComplementCenter() {
        if (this.lo() != this.hi()) {
            return this.complement().getCenter();
        }
        return this.hi() <= 0.0 ? this.hi() + Math.PI : this.hi() - Math.PI;
    }

    public boolean contains(double p) {
        if (p == -Math.PI) {
            p = Math.PI;
        }
        return this.fastContains(p);
    }

    public boolean fastContains(double p) {
        if (this.isInverted()) {
            return (p >= this.lo || p <= this.hi) && !this.isEmpty();
        }
        return p >= this.lo && p <= this.hi;
    }

    public boolean interiorContains(double p) {
        if (p == -Math.PI) {
            p = Math.PI;
        }
        if (this.isInverted()) {
            return p > this.lo || p < this.hi;
        }
        return p > this.lo && p < this.hi || this.isFull();
    }

    public boolean contains(S1Interval y) {
        if (this.isInverted()) {
            if (y.isInverted()) {
                return y.lo >= this.lo && y.hi <= this.hi;
            }
            return (y.lo >= this.lo || y.hi <= this.hi) && !this.isEmpty();
        }
        if (y.isInverted()) {
            return this.isFull() || y.isEmpty();
        }
        return y.lo >= this.lo && y.hi <= this.hi;
    }

    public boolean interiorContains(S1Interval y) {
        if (this.isInverted()) {
            if (!y.isInverted()) {
                return y.lo > this.lo || y.hi < this.hi;
            }
            return y.lo > this.lo && y.hi < this.hi || y.isEmpty();
        }
        if (y.isInverted()) {
            return this.isFull() || y.isEmpty();
        }
        return y.lo > this.lo && y.hi < this.hi || this.isFull();
    }

    public boolean intersects(S1Interval y) {
        if (this.isEmpty() || y.isEmpty()) {
            return false;
        }
        if (this.isInverted()) {
            return y.isInverted() || y.lo <= this.hi || y.hi >= this.lo;
        }
        if (y.isInverted()) {
            return y.lo <= this.hi || y.hi >= this.lo;
        }
        return y.lo <= this.hi && y.hi >= this.lo;
    }

    public boolean interiorIntersects(S1Interval y) {
        if (this.isEmpty() || y.isEmpty() || this.lo == this.hi) {
            return false;
        }
        if (this.isInverted()) {
            return y.isInverted() || y.lo < this.hi || y.hi > this.lo;
        }
        if (y.isInverted()) {
            return y.lo < this.hi || y.hi > this.lo;
        }
        return y.lo < this.hi && y.hi > this.lo || this.isFull();
    }

    public double getDirectedHausdorffDistance(S1Interval y) {
        if (y.contains(this)) {
            return 0.0;
        }
        if (y.isEmpty()) {
            return Math.PI;
        }
        double yComplementCenter = y.getComplementCenter();
        if (this.contains(yComplementCenter)) {
            return S1Interval.positiveDistance(y.hi(), yComplementCenter);
        }
        double hiHi = new S1Interval(y.hi(), yComplementCenter).contains(this.hi()) ? S1Interval.positiveDistance(y.hi(), this.hi()) : 0.0;
        double loLo = new S1Interval(yComplementCenter, y.lo()).contains(this.lo()) ? S1Interval.positiveDistance(this.lo(), y.lo()) : 0.0;
        return Math.max(hiHi, loLo);
    }

    @CheckReturnValue
    public S1Interval addPoint(double p) {
        double dhi;
        if (p == -Math.PI) {
            p = Math.PI;
        }
        if (this.fastContains(p)) {
            return new S1Interval(this);
        }
        if (this.isEmpty()) {
            return S1Interval.fromPoint(p);
        }
        double dlo = S1Interval.positiveDistance(p, this.lo);
        if (dlo < (dhi = S1Interval.positiveDistance(this.hi, p))) {
            return new S1Interval(p, this.hi);
        }
        return new S1Interval(this.lo, p);
    }

    public double clampPoint(double p) {
        double dhi;
        if (p == -Math.PI) {
            p = Math.PI;
        }
        if (this.fastContains(p)) {
            return p;
        }
        double dlo = S1Interval.positiveDistance(p, this.lo);
        return dlo < (dhi = S1Interval.positiveDistance(this.hi, p)) ? this.lo : this.hi;
    }

    @CheckReturnValue
    public S1Interval expanded(double margin) {
        S1Interval copy = new S1Interval(this);
        copy.expandedInternal(margin);
        return copy;
    }

    void expandedInternal(double margin) {
        if (margin >= 0.0) {
            if (this.isEmpty()) {
                return;
            }
            if (this.getLength() + 2.0 * margin + 2.0 * S2.DBL_EPSILON >= Math.PI * 2) {
                this.setFull();
                return;
            }
        } else {
            if (this.isFull()) {
                return;
            }
            if (this.getLength() + 2.0 * margin - 2.0 * S2.DBL_EPSILON <= 0.0) {
                this.setEmpty();
                return;
            }
        }
        this.set(Platform.IEEEremainder(this.lo - margin, Math.PI * 2), Platform.IEEEremainder(this.hi + margin, Math.PI * 2), false);
        if (this.lo <= -Math.PI) {
            this.lo = Math.PI;
        }
    }

    @CheckReturnValue
    public S1Interval union(S1Interval y) {
        S1Interval result = new S1Interval(this);
        result.unionInternal(y);
        return result;
    }

    void unionInternal(S1Interval y) {
        if (!y.isEmpty()) {
            if (this.fastContains(y.lo)) {
                if (this.fastContains(y.hi)) {
                    if (!this.contains(y)) {
                        this.setFull();
                    }
                } else {
                    this.hi = y.hi;
                }
            } else if (this.fastContains(y.hi)) {
                this.lo = y.lo;
            } else if (this.isEmpty() || y.fastContains(this.lo)) {
                this.lo = y.lo;
                this.hi = y.hi;
            } else {
                double dhi;
                double dlo = S1Interval.positiveDistance(y.hi, this.lo);
                if (dlo < (dhi = S1Interval.positiveDistance(this.hi, y.lo))) {
                    this.lo = y.lo;
                } else {
                    this.hi = y.hi;
                }
            }
        }
    }

    public double get(int endpoint) {
        if (endpoint < 0 || endpoint > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return endpoint == 0 ? this.lo : this.hi;
    }

    @CheckReturnValue
    public S1Interval intersection(S1Interval y) {
        S1Interval result = new S1Interval(this);
        result.intersectionInternal(y);
        return result;
    }

    void intersectionInternal(S1Interval y) {
        if (y.isEmpty()) {
            this.setEmpty();
        } else if (this.fastContains(y.lo)) {
            if (this.fastContains(y.hi)) {
                if (y.getLength() < this.getLength()) {
                    this.set(y.lo, y.hi, true);
                }
            } else {
                this.set(y.lo, this.hi, true);
            }
        } else if (this.fastContains(y.hi)) {
            this.set(this.lo, y.hi, true);
        } else if (!y.fastContains(this.lo)) {
            this.setEmpty();
        }
    }

    public boolean approxEquals(S1Interval y, double maxError) {
        if (this.isEmpty()) {
            return y.getLength() <= 2.0 * maxError;
        }
        if (y.isEmpty()) {
            return this.getLength() <= 2.0 * maxError;
        }
        if (this.isFull()) {
            return y.getLength() >= 2.0 * (Math.PI - maxError);
        }
        if (y.isFull()) {
            return this.getLength() >= 2.0 * (Math.PI - maxError);
        }
        return Math.abs(Platform.IEEEremainder(y.lo - this.lo, Math.PI * 2)) <= maxError && Math.abs(Platform.IEEEremainder(y.hi - this.hi, Math.PI * 2)) <= maxError && Math.abs(this.getLength() - y.getLength()) <= 2.0 * maxError;
    }

    public boolean approxEquals(S1Interval y) {
        return this.approxEquals(y, 1.0E-15);
    }

    public boolean equals(Object that) {
        if (that instanceof S1Interval) {
            S1Interval thatInterval = (S1Interval)that;
            return this.lo == thatInterval.lo && this.hi == thatInterval.hi;
        }
        return false;
    }

    public int hashCode() {
        long value = 17L;
        value = 37L * value + Double.doubleToLongBits(this.lo);
        value = 37L * value + Double.doubleToLongBits(this.hi);
        return (int)(value >>> 32 ^ value);
    }

    public String toString() {
        return "[" + this.lo + ", " + this.hi + "]";
    }

    public static double positiveDistance(double a, double b) {
        double d = b - a;
        if (d >= 0.0) {
            return d;
        }
        return b + Math.PI - (a - Math.PI);
    }
}

