/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.stream.Stream;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.utils.InscribedCircle;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_MaximumInscribedCircle", argNames={"geometry"})
public class ST_MaximumInscribedCircle {
    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geometry) throws ParseException {
        InscribedCircle inscribedCircle = Functions.maximumInscribedCircle(GeometrySerde.deserialize(geometry));
        return Stream.of(new OutputRow(inscribedCircle));
    }

    public static class OutputRow {
        public final byte[] center;
        public final byte[] nearest;
        public final double radius;

        public OutputRow(InscribedCircle inscribedCircle) {
            this.center = GeometrySerde.serialize(inscribedCircle.center);
            this.nearest = GeometrySerde.serialize(inscribedCircle.nearest);
            this.radius = inscribedCircle.radius;
        }
    }
}

