/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.source.arrow.converter;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.common.source.arrow.converter.Converter;
import org.apache.seatunnel.shade.org.apache.arrow.vector.complex.StructVector;
import org.apache.seatunnel.shade.org.apache.arrow.vector.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructConverter
implements Converter<StructVector> {
    private static final Logger log = LoggerFactory.getLogger(StructConverter.class);

    @Override
    public Object convert(int rowIndex, StructVector fieldVector) {
        return fieldVector.isNull(rowIndex) ? null : fieldVector.getObject(rowIndex);
    }

    @Override
    public Object convert(int rowIndex, StructVector fieldVector, Map<String, Function> genericsConverters) {
        Map valueMap = fieldVector.getObject(rowIndex);
        return valueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Optional<Function> optional = Optional.ofNullable((Function)genericsConverters.get(e.getKey()));
            if (optional.isPresent()) {
                return optional.get().apply(e.getValue());
            }
            log.warn("No converter found for key:{}", e.getKey());
            return e.getValue();
        }));
    }

    @Override
    public boolean support(Types.MinorType type) {
        return Types.MinorType.STRUCT == type;
    }
}

