/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.TopicQueueMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;

public class TopicQueueMappingManager
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final transient Lock lock = new ReentrantLock();
    private final DataVersion dataVersion = new DataVersion();
    private transient BrokerController brokerController;
    private final ConcurrentMap<String, TopicQueueMappingDetail> topicQueueMappingTable = new ConcurrentHashMap<String, TopicQueueMappingDetail>();

    public TopicQueueMappingManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateTopicQueueMapping(TopicQueueMappingDetail newDetail, boolean force, boolean isClean, boolean flush) throws Exception {
        TopicQueueMappingDetail oldDetail;
        boolean updated;
        boolean locked;
        block22: {
            block21: {
                block20: {
                    block19: {
                        locked = false;
                        updated = false;
                        oldDetail = null;
                        if (this.lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                            locked = true;
                            break block19;
                        }
                        if (locked) {
                            this.lock.unlock();
                        }
                        if (!updated || !flush) return;
                        this.dataVersion.nextVersion();
                        this.persist();
                        log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
                        return;
                    }
                    if (newDetail != null) break block20;
                    if (locked) {
                        this.lock.unlock();
                    }
                    if (!updated || !flush) return;
                    this.dataVersion.nextVersion();
                    this.persist();
                    log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
                    return;
                }
                assert (newDetail.getBname().equals(this.brokerController.getBrokerConfig().getBrokerName()));
                newDetail.getHostedQueues().forEach((queueId, items) -> TopicQueueMappingUtils.checkLogicQueueMappingItemOffset((List)items));
                oldDetail = (TopicQueueMappingDetail)this.topicQueueMappingTable.get(newDetail.getTopic());
                if (oldDetail != null) break block21;
                this.topicQueueMappingTable.put(newDetail.getTopic(), newDetail);
                updated = true;
                if (locked) {
                    this.lock.unlock();
                }
                if (!updated || !flush) return;
                this.dataVersion.nextVersion();
                this.persist();
                log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
                return;
            }
            if (!force) break block22;
            oldDetail.getHostedQueues().forEach((queueId, items) -> newDetail.getHostedQueues().putIfAbsent(queueId, items));
            this.topicQueueMappingTable.put(newDetail.getTopic(), newDetail);
            updated = true;
            if (locked) {
                this.lock.unlock();
            }
            if (!updated || !flush) return;
            this.dataVersion.nextVersion();
            this.persist();
            log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
            return;
        }
        try {
            if (newDetail.getEpoch() < oldDetail.getEpoch()) {
                throw new RuntimeException(String.format("Can't accept data with small epoch %d < %d", newDetail.getEpoch(), oldDetail.getEpoch()));
            }
            if (!newDetail.getScope().equals(oldDetail.getScope())) {
                throw new RuntimeException(String.format("Can't accept data with unmatched scope %s != %s", newDetail.getScope(), oldDetail.getScope()));
            }
            boolean epochEqual = newDetail.getEpoch() == oldDetail.getEpoch();
            for (Integer globalId : oldDetail.getHostedQueues().keySet()) {
                List oldItems = (List)oldDetail.getHostedQueues().get(globalId);
                List newItems = (List)newDetail.getHostedQueues().get(globalId);
                if (newItems == null) {
                    if (epochEqual) {
                        throw new RuntimeException("Cannot accept equal epoch with null data");
                    }
                    newDetail.getHostedQueues().put(globalId, oldItems);
                    continue;
                }
                TopicQueueMappingUtils.makeSureLogicQueueMappingItemImmutable((List)oldItems, (List)newItems, (boolean)epochEqual, (boolean)isClean);
            }
            this.topicQueueMappingTable.put(newDetail.getTopic(), newDetail);
            updated = true;
            if (locked) {
                this.lock.unlock();
            }
            if (!updated || !flush) return;
        }
        catch (Throwable throwable) {
            if (locked) {
                this.lock.unlock();
            }
            if (!updated || !flush) throw throwable;
            this.dataVersion.nextVersion();
            this.persist();
            log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
            throw throwable;
        }
        this.dataVersion.nextVersion();
        this.persist();
        log.info("Update topic queue mapping from [{}] to [{}], force {}", new Object[]{oldDetail, newDetail, force});
    }

    public void delete(String topic) {
        TopicQueueMappingDetail old = (TopicQueueMappingDetail)this.topicQueueMappingTable.remove(topic);
        if (old != null) {
            log.info("delete topic queue mapping OK, static topic queue mapping: {}", (Object)old);
            this.dataVersion.nextVersion();
            this.persist();
        } else {
            log.warn("delete topic queue mapping failed, static topic: {} not exists", (Object)topic);
        }
    }

    public TopicQueueMappingDetail getTopicQueueMapping(String topic) {
        return (TopicQueueMappingDetail)this.topicQueueMappingTable.get(topic);
    }

    public String encode(boolean pretty) {
        TopicQueueMappingSerializeWrapper wrapper = new TopicQueueMappingSerializeWrapper();
        wrapper.setTopicQueueMappingInfoMap(this.topicQueueMappingTable);
        wrapper.setDataVersion(this.dataVersion);
        if (pretty) {
            return JSON.toJSONString((Object)wrapper, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
        }
        return JSON.toJSONString((Object)wrapper);
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getTopicQueueMappingPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        TopicQueueMappingSerializeWrapper wrapper;
        if (jsonString != null && (wrapper = (TopicQueueMappingSerializeWrapper)TopicQueueMappingSerializeWrapper.fromJson((String)jsonString, TopicQueueMappingSerializeWrapper.class)) != null) {
            this.topicQueueMappingTable.putAll(wrapper.getTopicQueueMappingInfoMap());
            this.dataVersion.assignNewOne(wrapper.getDataVersion());
        }
    }

    public ConcurrentMap<String, TopicQueueMappingDetail> getTopicQueueMappingTable() {
        return this.topicQueueMappingTable;
    }

    public ConcurrentMap<String, TopicQueueMappingDetail> subTopicQueueMappingTable(Set<String> topicSet) {
        if (MapUtils.isEmpty(this.topicQueueMappingTable) || CollectionUtils.isEmpty(topicSet)) {
            return Maps.newConcurrentMap();
        }
        return this.topicQueueMappingTable.entrySet().stream().filter(e -> topicSet.contains(e.getKey())).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public TopicQueueMappingContext buildTopicQueueMappingContext(TopicRequestHeader requestHeader) {
        return this.buildTopicQueueMappingContext(requestHeader, false);
    }

    public TopicQueueMappingContext buildTopicQueueMappingContext(TopicRequestHeader requestHeader, boolean selectOneWhenMiss) {
        TopicQueueMappingDetail mappingDetail;
        if (requestHeader.getLo() != null && Boolean.FALSE.equals(requestHeader.getLo())) {
            return new TopicQueueMappingContext(requestHeader.getTopic(), null, null, null, null);
        }
        String topic = requestHeader.getTopic();
        Integer globalId = null;
        if (requestHeader instanceof TopicQueueRequestHeader) {
            globalId = ((TopicQueueRequestHeader)requestHeader).getQueueId();
        }
        if ((mappingDetail = this.getTopicQueueMapping(topic)) == null) {
            return new TopicQueueMappingContext(topic, null, null, null, null);
        }
        assert (mappingDetail.getBname().equals(this.brokerController.getBrokerConfig().getBrokerName()));
        if (globalId == null) {
            return new TopicQueueMappingContext(topic, null, mappingDetail, null, null);
        }
        if (globalId < 0 && !selectOneWhenMiss) {
            return new TopicQueueMappingContext(topic, globalId, mappingDetail, null, null);
        }
        if (globalId < 0) {
            try {
                if (!mappingDetail.getHostedQueues().isEmpty()) {
                    globalId = (Integer)mappingDetail.getHostedQueues().keySet().iterator().next();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (globalId < 0) {
            return new TopicQueueMappingContext(topic, globalId, mappingDetail, null, null);
        }
        List mappingItemList = TopicQueueMappingDetail.getMappingInfo((TopicQueueMappingDetail)mappingDetail, (Integer)globalId);
        LogicQueueMappingItem leaderItem = null;
        if (mappingItemList != null && mappingItemList.size() > 0) {
            leaderItem = (LogicQueueMappingItem)mappingItemList.get(mappingItemList.size() - 1);
        }
        return new TopicQueueMappingContext(topic, globalId, mappingDetail, mappingItemList, leaderItem);
    }

    public RemotingCommand rewriteRequestForStaticTopic(TopicQueueRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", requestHeader.getTopic(), requestHeader.getQueueId(), mappingDetail.getBname()));
            }
            LogicQueueMappingItem mappingItem = mappingContext.getLeaderItem();
            requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
            return null;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }
}

