/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.offset.ConsumerOrderInfoManager;
import org.apache.rocketmq.broker.pop.PopConsumerLockService;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class ChangeInvisibleTimeProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final String reviveTopic;

    public ChangeInvisibleTimeProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.reviveTopic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        CompletableFuture<RemotingCommand> responseFuture = this.processRequestAsync(channel, request, brokerAllowSuspend);
        if (!this.brokerController.getBrokerConfig().isAppendCkAsync() || !this.brokerController.getBrokerConfig().isAppendAckAsync()) {
            RemotingCommand response2;
            try {
                response2 = responseFuture.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                response2 = RemotingCommand.createResponseCommand(ChangeInvisibleTimeResponseHeader.class);
                response2.setCode(1);
                response2.setOpaque(request.getOpaque());
                POP_LOGGER.error("append checkpoint or ack origin failed", (Throwable)e);
            }
            return response2;
        }
        ((CompletableFuture)responseFuture.thenAccept(response -> this.doResponse(channel, request, (RemotingCommand)response))).exceptionally(throwable -> {
            RemotingCommand response = RemotingCommand.createResponseCommand(ChangeInvisibleTimeResponseHeader.class);
            response.setCode(1);
            response.setOpaque(request.getOpaque());
            this.doResponse(channel, request, response);
            POP_LOGGER.error("append checkpoint or ack origin failed", throwable);
            return null;
        });
        return null;
    }

    public CompletableFuture<RemotingCommand> processRequestAsync(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        long maxOffset;
        ChangeInvisibleTimeRequestHeader requestHeader = (ChangeInvisibleTimeRequestHeader)request.decodeCommandCustomHeader(ChangeInvisibleTimeRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(ChangeInvisibleTimeResponseHeader.class);
        response.setCode(0);
        response.setOpaque(request.getOpaque());
        ChangeInvisibleTimeResponseHeader responseHeader = (ChangeInvisibleTimeResponseHeader)response.readCustomHeader();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return CompletableFuture.completedFuture(response);
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums() || requestHeader.getQueueId() < 0) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            POP_LOGGER.warn(errorInfo);
            response.setCode(13);
            response.setRemark(errorInfo);
            return CompletableFuture.completedFuture(response);
        }
        long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        try {
            maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        }
        catch (ConsumeQueueException e) {
            throw new RemotingCommandException("Failed to get max consume offset", (Throwable)e);
        }
        if (requestHeader.getOffset() < minOffset || requestHeader.getOffset() >= maxOffset) {
            response.setCode(208);
            return CompletableFuture.completedFuture(response);
        }
        String[] extraInfo = ExtraInfoUtil.split((String)requestHeader.getExtraInfo());
        if (this.brokerController.getBrokerConfig().isPopConsumerKVServiceEnable()) {
            if (ExtraInfoUtil.isOrder((String[])extraInfo)) {
                return this.processChangeInvisibleTimeForOrderNew(requestHeader, extraInfo, response, responseHeader);
            }
            try {
                long current = System.currentTimeMillis();
                this.brokerController.getPopConsumerService().changeInvisibilityDuration(ExtraInfoUtil.getPopTime((String[])extraInfo), ExtraInfoUtil.getInvisibleTime((String[])extraInfo), current, requestHeader.getInvisibleTime(), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getOffset());
                responseHeader.setInvisibleTime(requestHeader.getInvisibleTime().longValue());
                responseHeader.setPopTime(current);
                responseHeader.setReviveQid(ExtraInfoUtil.getReviveQid((String[])extraInfo));
            }
            catch (Exception e) {
                response.setCode(1);
            }
            return CompletableFuture.completedFuture(response);
        }
        if (ExtraInfoUtil.isOrder((String[])extraInfo)) {
            return CompletableFuture.completedFuture(this.processChangeInvisibleTimeForOrder(requestHeader, extraInfo, response, responseHeader));
        }
        long now = System.currentTimeMillis();
        CompletableFuture<Boolean> futureResult = this.appendCheckPointThenAckOrigin(requestHeader, ExtraInfoUtil.getReviveQid((String[])extraInfo), requestHeader.getQueueId(), requestHeader.getOffset(), now, extraInfo);
        return futureResult.thenCompose(result -> {
            if (result.booleanValue()) {
                responseHeader.setInvisibleTime(requestHeader.getInvisibleTime().longValue());
                responseHeader.setPopTime(now);
                responseHeader.setReviveQid(ExtraInfoUtil.getReviveQid((String[])extraInfo));
            } else {
                response.setCode(1);
            }
            return CompletableFuture.completedFuture(response);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RemotingCommand> processChangeInvisibleTimeForOrderNew(ChangeInvisibleTimeRequestHeader requestHeader, String[] extraInfo, RemotingCommand response, ChangeInvisibleTimeResponseHeader responseHeader) {
        String groupId = requestHeader.getConsumerGroup();
        String topicId = requestHeader.getTopic();
        Integer queueId = requestHeader.getQueueId();
        long popTime = ExtraInfoUtil.getPopTime((String[])extraInfo);
        PopConsumerLockService consumerLockService = this.brokerController.getPopConsumerService().getConsumerLockService();
        ConsumerOffsetManager consumerOffsetManager = this.brokerController.getConsumerOffsetManager();
        ConsumerOrderInfoManager consumerOrderInfoManager = this.brokerController.getConsumerOrderInfoManager();
        long oldOffset = consumerOffsetManager.queryOffset(groupId, topicId, queueId);
        if (requestHeader.getOffset() < oldOffset) {
            return CompletableFuture.completedFuture(response);
        }
        while (!consumerLockService.tryLock(groupId, topicId)) {
        }
        try {
            oldOffset = consumerOffsetManager.queryOffset(groupId, topicId, queueId);
            if (requestHeader.getOffset() < oldOffset) {
                CompletableFuture<RemotingCommand> completableFuture = CompletableFuture.completedFuture(response);
                return completableFuture;
            }
            long visibilityTimeout = System.currentTimeMillis() + requestHeader.getInvisibleTime();
            consumerOrderInfoManager.updateNextVisibleTime(topicId, groupId, queueId, requestHeader.getOffset(), popTime, visibilityTimeout);
            responseHeader.setInvisibleTime(visibilityTimeout - popTime);
            responseHeader.setPopTime(popTime);
            responseHeader.setReviveQid(ExtraInfoUtil.getReviveQid((String[])extraInfo));
        }
        finally {
            consumerLockService.unlock(groupId, topicId);
        }
        return CompletableFuture.completedFuture(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemotingCommand processChangeInvisibleTimeForOrder(ChangeInvisibleTimeRequestHeader requestHeader, String[] extraInfo, RemotingCommand response, ChangeInvisibleTimeResponseHeader responseHeader) {
        long popTime = ExtraInfoUtil.getPopTime((String[])extraInfo);
        long oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
        if (requestHeader.getOffset() < oldOffset) {
            return response;
        }
        while (!this.brokerController.getPopMessageProcessor().getQueueLockManager().tryLock(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId())) {
        }
        try {
            oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
            if (requestHeader.getOffset() < oldOffset) {
                RemotingCommand remotingCommand = response;
                return remotingCommand;
            }
            long nextVisibleTime = System.currentTimeMillis() + requestHeader.getInvisibleTime();
            this.brokerController.getConsumerOrderInfoManager().updateNextVisibleTime(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId(), requestHeader.getOffset(), popTime, nextVisibleTime);
            responseHeader.setInvisibleTime(nextVisibleTime - popTime);
            responseHeader.setPopTime(popTime);
            responseHeader.setReviveQid(ExtraInfoUtil.getReviveQid((String[])extraInfo));
        }
        finally {
            this.brokerController.getPopMessageProcessor().getQueueLockManager().unLock(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId());
        }
        return response;
    }

    private CompletableFuture<Boolean> ackOrigin(ChangeInvisibleTimeRequestHeader requestHeader, String[] extraInfo) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        AckMsg ackMsg = new AckMsg();
        ackMsg.setAckOffset(requestHeader.getOffset().longValue());
        ackMsg.setStartOffset(ExtraInfoUtil.getCkQueueOffset((String[])extraInfo).longValue());
        ackMsg.setConsumerGroup(requestHeader.getConsumerGroup());
        ackMsg.setTopic(requestHeader.getTopic());
        ackMsg.setQueueId(requestHeader.getQueueId().intValue());
        ackMsg.setPopTime(ExtraInfoUtil.getPopTime((String[])extraInfo).longValue());
        ackMsg.setBrokerName(ExtraInfoUtil.getBrokerName((String[])extraInfo));
        int rqId = ExtraInfoUtil.getReviveQid((String[])extraInfo);
        this.brokerController.getBrokerStatsManager().incBrokerAckNums(1);
        this.brokerController.getBrokerStatsManager().incGroupAckNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), 1);
        if (this.brokerController.getPopMessageProcessor().getPopBufferMergeService().addAk(rqId, ackMsg)) {
            return CompletableFuture.completedFuture(true);
        }
        msgInner.setTopic(this.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ackMsg).getBytes(StandardCharsets.UTF_8));
        msgInner.setQueueId(rqId);
        msgInner.setTags("ack");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(ExtraInfoUtil.getPopTime((String[])extraInfo) + ExtraInfoUtil.getInvisibleTime((String[])extraInfo));
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        return ((CompletableFuture)this.brokerController.getEscapeBridge().asyncPutMessageToSpecificQueue(msgInner).thenCompose(putMessageResult -> {
            if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
                POP_LOGGER.error("change Invisible, put ack msg fail: {}, {}", (Object)ackMsg, putMessageResult);
            }
            PopMetricsManager.incPopReviveAckPutCount(ackMsg, putMessageResult.getPutMessageStatus());
            return CompletableFuture.completedFuture(true);
        })).exceptionally(e -> {
            POP_LOGGER.error("change Invisible, put ack msg error: {}, {}", (Object)requestHeader.getExtraInfo(), (Object)e.getMessage());
            return false;
        });
    }

    private CompletableFuture<Boolean> appendCheckPointThenAckOrigin(ChangeInvisibleTimeRequestHeader requestHeader, int reviveQid, int queueId, long offset, long popTime, String[] extraInfo) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(this.reviveTopic);
        PopCheckPoint ck = new PopCheckPoint();
        ck.setBitMap(0);
        ck.setNum((byte)1);
        ck.setPopTime(popTime);
        ck.setInvisibleTime(requestHeader.getInvisibleTime().longValue());
        ck.setStartOffset(offset);
        ck.setCId(requestHeader.getConsumerGroup());
        ck.setTopic(requestHeader.getTopic());
        ck.setQueueId(queueId);
        ck.addDiff(0);
        ck.setBrokerName(ExtraInfoUtil.getBrokerName((String[])extraInfo));
        msgInner.setBody(JSON.toJSONString((Object)ck).getBytes(StandardCharsets.UTF_8));
        msgInner.setQueueId(reviveQid);
        msgInner.setTags("ck");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(ck.getReviveTime() - PopAckConstants.ackTimeInterval);
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genCkUniqueId(ck));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        return ((CompletableFuture)this.brokerController.getEscapeBridge().asyncPutMessageToSpecificQueue(msgInner).thenCompose(putMessageResult -> {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("change Invisible, appendCheckPoint, topic {}, queueId {},reviveId {}, cid {}, startOffset {}, rt {}, result {}", new Object[]{requestHeader.getTopic(), queueId, reviveQid, requestHeader.getConsumerGroup(), offset, ck.getReviveTime(), putMessageResult});
            }
            if (putMessageResult != null) {
                PopMetricsManager.incPopReviveCkPutCount(ck, putMessageResult.getPutMessageStatus());
                if (putMessageResult.isOk()) {
                    this.brokerController.getBrokerStatsManager().incBrokerCkNums(1);
                    this.brokerController.getBrokerStatsManager().incGroupCkNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), 1);
                }
            }
            if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
                POP_LOGGER.error("change invisible, put new ck error: {}", putMessageResult);
                return CompletableFuture.completedFuture(false);
            }
            return this.ackOrigin(requestHeader, extraInfo);
        })).exceptionally(throwable -> {
            POP_LOGGER.error("change invisible, put new ck error", throwable);
            return null;
        });
    }

    protected void doResponse(Channel channel, RemotingCommand request, RemotingCommand response) {
        NettyRemotingAbstract.writeResponse((Channel)channel, (RemotingCommand)request, (RemotingCommand)response);
    }
}

