/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.metrics;

import com.google.common.base.Splitter;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.exporter.logging.otlp.OtlpJsonLoggingMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.metrics.ConsumerAttr;
import org.apache.rocketmq.broker.metrics.ConsumerLagCalculator;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.metrics.ProducerAttr;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.metrics.MetricsExporterType;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.store.MessageStore;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class BrokerMetricsManager {
    private static final org.apache.rocketmq.logging.org.slf4j.Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerConfig brokerConfig;
    private final MessageStore messageStore;
    private final BrokerController brokerController;
    private final ConsumerLagCalculator consumerLagCalculator;
    private static final Map<String, String> LABEL_MAP = new HashMap<String, String>();
    private OtlpGrpcMetricExporter metricExporter;
    private PeriodicMetricReader periodicMetricReader;
    private PrometheusHttpServer prometheusHttpServer;
    private MetricExporter loggingMetricExporter;
    private Meter brokerMeter;
    public static Supplier<AttributesBuilder> attributesBuilderSupplier = Attributes::builder;
    public static ObservableLongGauge processorWatermark = new NopObservableLongGauge();
    public static ObservableLongGauge brokerPermission = new NopObservableLongGauge();
    public static ObservableLongGauge topicNum = new NopObservableLongGauge();
    public static ObservableLongGauge consumerGroupNum = new NopObservableLongGauge();
    public static LongCounter messagesInTotal = new NopLongCounter();
    public static LongCounter messagesOutTotal = new NopLongCounter();
    public static LongCounter throughputInTotal = new NopLongCounter();
    public static LongCounter throughputOutTotal = new NopLongCounter();
    public static LongHistogram messageSize = new NopLongHistogram();
    public static LongHistogram topicCreateExecuteTime = new NopLongHistogram();
    public static LongHistogram consumerGroupCreateExecuteTime = new NopLongHistogram();
    public static ObservableLongGauge producerConnection = new NopObservableLongGauge();
    public static ObservableLongGauge consumerConnection = new NopObservableLongGauge();
    public static ObservableLongGauge consumerLagMessages = new NopObservableLongGauge();
    public static ObservableLongGauge consumerLagLatency = new NopObservableLongGauge();
    public static ObservableLongGauge consumerInflightMessages = new NopObservableLongGauge();
    public static ObservableLongGauge consumerQueueingLatency = new NopObservableLongGauge();
    public static ObservableLongGauge consumerReadyMessages = new NopObservableLongGauge();
    public static LongCounter sendToDlqMessages = new NopLongCounter();
    public static ObservableLongGauge halfMessages = new NopObservableLongGauge();
    public static LongCounter commitMessagesTotal = new NopLongCounter();
    public static LongCounter rollBackMessagesTotal = new NopLongCounter();
    public static LongHistogram transactionFinishLatency = new NopLongHistogram();
    public static final List<String> SYSTEM_GROUP_PREFIX_LIST = new ArrayList<String>(){
        {
            this.add("CID_RMQ_SYS_".toLowerCase());
        }
    };

    public BrokerMetricsManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerConfig = brokerController.getBrokerConfig();
        this.messageStore = brokerController.getMessageStore();
        this.consumerLagCalculator = new ConsumerLagCalculator(brokerController);
        this.init();
    }

    public static AttributesBuilder newAttributesBuilder() {
        if (attributesBuilderSupplier == null) {
            attributesBuilderSupplier = Attributes::builder;
        }
        AttributesBuilder attributesBuilder = attributesBuilderSupplier.get();
        LABEL_MAP.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder;
    }

    private Attributes buildLagAttributes(ConsumerLagCalculator.BaseCalculateResult result) {
        AttributesBuilder attributesBuilder = BrokerMetricsManager.newAttributesBuilder();
        attributesBuilder.put("consumer_group", result.group);
        attributesBuilder.put("topic", result.topic);
        attributesBuilder.put("is_retry", result.isRetry);
        attributesBuilder.put("is_system", BrokerMetricsManager.isSystem(result.topic, result.group));
        return attributesBuilder.build();
    }

    public static boolean isRetryOrDlqTopic(String topic) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            return false;
        }
        return topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%");
    }

    public static boolean isSystemGroup(String group) {
        if (StringUtils.isBlank((CharSequence)group)) {
            return false;
        }
        String groupInLowerCase = group.toLowerCase();
        for (String prefix : SYSTEM_GROUP_PREFIX_LIST) {
            if (!groupInLowerCase.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystem(String topic, String group) {
        return TopicValidator.isSystemTopic((String)topic) || BrokerMetricsManager.isSystemGroup(group);
    }

    public static TopicMessageType getMessageType(SendMessageRequestHeader requestHeader) {
        Map properties = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        String traFlag = (String)properties.get("TRAN_MSG");
        TopicMessageType topicMessageType = TopicMessageType.NORMAL;
        if (Boolean.parseBoolean(traFlag)) {
            topicMessageType = TopicMessageType.TRANSACTION;
        } else if (properties.containsKey("__SHARDINGKEY")) {
            topicMessageType = TopicMessageType.FIFO;
        } else if (properties.get("__STARTDELIVERTIME") != null || properties.get("DELAY") != null || properties.get("TIMER_DELIVER_MS") != null || properties.get("TIMER_DELAY_SEC") != null || properties.get("TIMER_DELAY_MS") != null) {
            topicMessageType = TopicMessageType.DELAY;
        }
        return topicMessageType;
    }

    public Meter getBrokerMeter() {
        return this.brokerMeter;
    }

    private boolean checkConfig() {
        if (this.brokerConfig == null) {
            return false;
        }
        MetricsExporterType exporterType = this.brokerConfig.getMetricsExporterType();
        if (!exporterType.isEnable()) {
            return false;
        }
        switch (exporterType) {
            case OTLP_GRPC: {
                return StringUtils.isNotBlank((CharSequence)this.brokerConfig.getMetricsGrpcExporterTarget());
            }
            case PROM: {
                return true;
            }
            case LOG: {
                return true;
            }
        }
        return false;
    }

    private void init() {
        MetricsExporterType metricsExporterType = this.brokerConfig.getMetricsExporterType();
        if (metricsExporterType == MetricsExporterType.DISABLE) {
            return;
        }
        if (!this.checkConfig()) {
            LOGGER.error("check metrics config failed, will not export metrics");
            return;
        }
        String labels = this.brokerConfig.getMetricsLabel();
        if (StringUtils.isNotBlank((CharSequence)labels)) {
            List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)labels);
            for (String item : kvPairs) {
                String[] split = item.split(":");
                if (split.length != 2) {
                    LOGGER.warn("metricsLabel is not valid: {}", (Object)labels);
                    continue;
                }
                LABEL_MAP.put(split[0], split[1]);
            }
        }
        if (this.brokerConfig.isMetricsInDelta()) {
            LABEL_MAP.put("aggregation", "delta");
        }
        LABEL_MAP.put("node_type", "broker");
        LABEL_MAP.put("cluster", this.brokerConfig.getBrokerClusterName());
        LABEL_MAP.put("node_id", this.brokerConfig.getBrokerName());
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder().setResource(Resource.empty());
        if (metricsExporterType == MetricsExporterType.OTLP_GRPC) {
            String endpoint = this.brokerConfig.getMetricsGrpcExporterTarget();
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            OtlpGrpcMetricExporterBuilder metricExporterBuilder = OtlpGrpcMetricExporter.builder().setEndpoint(endpoint).setTimeout(this.brokerConfig.getMetricGrpcExporterTimeOutInMills(), TimeUnit.MILLISECONDS).setAggregationTemporalitySelector(type -> {
                if (this.brokerConfig.isMetricsInDelta() && (type == InstrumentType.COUNTER || type == InstrumentType.OBSERVABLE_COUNTER || type == InstrumentType.HISTOGRAM)) {
                    return AggregationTemporality.DELTA;
                }
                return AggregationTemporality.CUMULATIVE;
            });
            String headers = this.brokerConfig.getMetricsGrpcExporterHeader();
            if (StringUtils.isNotBlank((CharSequence)headers)) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)headers);
                for (String item : kvPairs) {
                    String[] split = item.split(":");
                    if (split.length != 2) {
                        LOGGER.warn("metricsGrpcExporterHeader is not valid: {}", (Object)headers);
                        continue;
                    }
                    headerMap.put(split[0], split[1]);
                }
                headerMap.forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)metricExporterBuilder).addHeader(arg_0, arg_1));
            }
            this.metricExporter = metricExporterBuilder.build();
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.metricExporter).setInterval(this.brokerConfig.getMetricGrpcExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        if (metricsExporterType == MetricsExporterType.PROM) {
            String promExporterHost = this.brokerConfig.getMetricsPromExporterHost();
            if (StringUtils.isBlank((CharSequence)promExporterHost)) {
                promExporterHost = this.brokerConfig.getBrokerIP1();
            }
            this.prometheusHttpServer = PrometheusHttpServer.builder().setHost(promExporterHost).setPort(this.brokerConfig.getMetricsPromExporterPort()).build();
            providerBuilder.registerMetricReader((MetricReader)this.prometheusHttpServer);
        }
        if (metricsExporterType == MetricsExporterType.LOG) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            this.loggingMetricExporter = OtlpJsonLoggingMetricExporter.create((AggregationTemporality)(this.brokerConfig.isMetricsInDelta() ? AggregationTemporality.DELTA : AggregationTemporality.CUMULATIVE));
            Logger.getLogger(OtlpJsonLoggingMetricExporter.class.getName()).setLevel(Level.FINEST);
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.loggingMetricExporter).setInterval(this.brokerConfig.getMetricLoggingExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        this.registerMetricsView(providerBuilder);
        this.brokerMeter = OpenTelemetrySdk.builder().setMeterProvider(providerBuilder.build()).build().getMeter("broker-meter");
        this.initStatsMetrics();
        this.initRequestMetrics();
        this.initConnectionMetrics();
        this.initLagAndDlqMetrics();
        this.initTransactionMetrics();
        this.initOtherMetrics();
    }

    private void registerMetricsView(SdkMeterProviderBuilder providerBuilder) {
        ViewBuilder viewBuilder;
        List<Double> messageSizeBuckets = Arrays.asList(1024.0, 4096.0, 524288.0, 1048576.0, 2097152.0, 4194304.0);
        List<Double> commitLatencyBuckets = Arrays.asList(5.0, 60.0, 600.0, 3600.0, 43200.0, 86400.0);
        List<Double> createTimeBuckets = Arrays.asList(Duration.ofMillis(10L).toMillis(), Duration.ofMillis(100L).toMillis(), Duration.ofSeconds(1L).toMillis(), Duration.ofSeconds(3L).toMillis(), Duration.ofSeconds(5L).toMillis());
        InstrumentSelector messageSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_message_size").build();
        ViewBuilder messageSizeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(messageSizeBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)messageSizeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(messageSizeSelector, messageSizeViewBuilder.build());
        InstrumentSelector commitLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_finish_message_latency").build();
        ViewBuilder commitLatencyViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(commitLatencyBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)commitLatencyViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(commitLatencySelector, commitLatencyViewBuilder.build());
        InstrumentSelector createTopicTimeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_topic_create_execution_time").build();
        InstrumentSelector createSubGroupTimeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_consumer_group_create_execution_time").build();
        ViewBuilder createTopicTimeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(createTimeBuckets));
        ViewBuilder createSubGroupTimeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(createTimeBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)createTopicTimeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(createTopicTimeSelector, createTopicTimeViewBuilder.build());
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)createSubGroupTimeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(createSubGroupTimeSelector, createSubGroupTimeViewBuilder.build());
        for (Pair pair : RemotingMetricsManager.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        for (Pair pair : this.messageStore.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        for (Pair pair : PopMetricsManager.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        InstrumentSelector defaultCounterSelector = InstrumentSelector.builder().setType(InstrumentType.COUNTER).build();
        ViewBuilder viewBuilder2 = View.builder().setDescription("default view for counter.");
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder2, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(defaultCounterSelector, viewBuilder2.build());
        InstrumentSelector defaultGaugeSelector = InstrumentSelector.builder().setType(InstrumentType.OBSERVABLE_GAUGE).build();
        ViewBuilder defaultGaugeViewBuilder = View.builder().setDescription("default view for gauge.");
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)defaultGaugeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(defaultGaugeSelector, defaultGaugeViewBuilder.build());
    }

    private void initStatsMetrics() {
        processorWatermark = this.brokerMeter.gaugeBuilder("rocketmq_processor_watermark").setDescription("Request processor watermark").ofLongs().buildWithCallback(measurement -> {
            measurement.record((long)this.brokerController.getSendThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "send").build());
            measurement.record((long)this.brokerController.getAsyncPutThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "async_put").build());
            measurement.record((long)this.brokerController.getPullThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "pull").build());
            measurement.record((long)this.brokerController.getAckThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "ack").build());
            measurement.record((long)this.brokerController.getQueryThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "query_message").build());
            measurement.record((long)this.brokerController.getClientManagerThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "client_manager").build());
            measurement.record((long)this.brokerController.getHeartbeatThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "heartbeat").build());
            measurement.record((long)this.brokerController.getLitePullThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "lite_pull").build());
            measurement.record((long)this.brokerController.getEndTransactionThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "transaction").build());
            measurement.record((long)this.brokerController.getConsumerManagerThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "consumer_manager").build());
            measurement.record((long)this.brokerController.getAdminBrokerThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "admin").build());
            measurement.record((long)this.brokerController.getReplyThreadPoolQueue().size(), BrokerMetricsManager.newAttributesBuilder().put("processor", "reply").build());
        });
        brokerPermission = this.brokerMeter.gaugeBuilder("rocketmq_broker_permission").setDescription("Broker permission").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerConfig.getBrokerPermission(), BrokerMetricsManager.newAttributesBuilder().build()));
        topicNum = this.brokerMeter.gaugeBuilder("rocketmq_topic_number").setDescription("Active topic number").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerController.getTopicConfigManager().getTopicConfigTable().size(), BrokerMetricsManager.newAttributesBuilder().build()));
        consumerGroupNum = this.brokerMeter.gaugeBuilder("rocketmq_consumer_group_number").setDescription("Active subscription group number").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().size(), BrokerMetricsManager.newAttributesBuilder().build()));
    }

    private void initRequestMetrics() {
        messagesInTotal = this.brokerMeter.counterBuilder("rocketmq_messages_in_total").setDescription("Total number of incoming messages").build();
        messagesOutTotal = this.brokerMeter.counterBuilder("rocketmq_messages_out_total").setDescription("Total number of outgoing messages").build();
        throughputInTotal = this.brokerMeter.counterBuilder("rocketmq_throughput_in_total").setDescription("Total traffic of incoming messages").build();
        throughputOutTotal = this.brokerMeter.counterBuilder("rocketmq_throughput_out_total").setDescription("Total traffic of outgoing messages").build();
        messageSize = this.brokerMeter.histogramBuilder("rocketmq_message_size").setDescription("Incoming messages size").ofLongs().build();
        topicCreateExecuteTime = this.brokerMeter.histogramBuilder("rocketmq_topic_create_execution_time").setDescription("The distribution of create topic time").ofLongs().setUnit("milliseconds").build();
        consumerGroupCreateExecuteTime = this.brokerMeter.histogramBuilder("rocketmq_consumer_group_create_execution_time").setDescription("The distribution of create subscription time").ofLongs().setUnit("milliseconds").build();
    }

    private void initConnectionMetrics() {
        producerConnection = this.brokerMeter.gaugeBuilder("rocketmq_producer_connections").setDescription("Producer connections").ofLongs().buildWithCallback(measurement -> {
            HashMap<ProducerAttr, Integer> metricsMap = new HashMap<ProducerAttr, Integer>();
            this.brokerController.getProducerManager().getGroupChannelTable().values().stream().flatMap(map -> map.values().stream()).forEach(info -> {
                ProducerAttr attr = new ProducerAttr(info.getLanguage(), info.getVersion());
                Integer count = metricsMap.computeIfAbsent(attr, k -> 0);
                metricsMap.put(attr, count + 1);
            });
            metricsMap.forEach((attr, count) -> {
                Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("language", attr.language.name().toLowerCase()).put("version", MQVersion.getVersionDesc((int)attr.version).toLowerCase()).put("protocol_type", "remoting").build();
                measurement.record((long)count.intValue(), attributes);
            });
        });
        consumerConnection = this.brokerMeter.gaugeBuilder("rocketmq_consumer_connections").setDescription("Consumer connections").ofLongs().buildWithCallback(measurement -> {
            HashMap<ConsumerAttr, Integer> metricsMap = new HashMap<ConsumerAttr, Integer>();
            ConsumerManager consumerManager = this.brokerController.getConsumerManager();
            consumerManager.getConsumerTable().forEach((group, groupInfo) -> {
                if (groupInfo != null) {
                    groupInfo.getChannelInfoTable().values().forEach(info -> {
                        ConsumerAttr attr = new ConsumerAttr((String)group, info.getLanguage(), info.getVersion(), groupInfo.getConsumeType());
                        Integer count = metricsMap.computeIfAbsent(attr, k -> 0);
                        metricsMap.put(attr, count + 1);
                    });
                }
            });
            metricsMap.forEach((attr, count) -> {
                Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("consumer_group", attr.group).put("language", attr.language.name().toLowerCase()).put("version", MQVersion.getVersionDesc((int)attr.version).toLowerCase()).put("consume_mode", attr.consumeMode.getTypeCN().toLowerCase()).put("protocol_type", "remoting").put("is_system", BrokerMetricsManager.isSystemGroup(attr.group)).build();
                measurement.record((long)count.intValue(), attributes);
            });
        });
    }

    private void initLagAndDlqMetrics() {
        consumerLagMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_lag_messages").setDescription("Consumer lag messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateLag(result -> measurement.record(result.lag, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        consumerLagLatency = this.brokerMeter.gaugeBuilder("rocketmq_consumer_lag_latency").setDescription("Consumer lag time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateLag(result -> {
            long latency = 0L;
            long curTimeStamp = System.currentTimeMillis();
            if (result.earliestUnconsumedTimestamp != 0L) {
                latency = curTimeStamp - result.earliestUnconsumedTimestamp;
            }
            measurement.record(latency, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result));
        }));
        consumerInflightMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_inflight_messages").setDescription("Consumer inflight messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateInflight(result -> measurement.record(result.inFlight, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        consumerQueueingLatency = this.brokerMeter.gaugeBuilder("rocketmq_consumer_queueing_latency").setDescription("Consumer queueing time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateInflight(result -> {
            long latency = 0L;
            long curTimeStamp = System.currentTimeMillis();
            if (result.earliestUnPulledTimestamp != 0L) {
                latency = curTimeStamp - result.earliestUnPulledTimestamp;
            }
            measurement.record(latency, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result));
        }));
        consumerReadyMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_ready_messages").setDescription("Consumer ready messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateAvailable(result -> measurement.record(result.available, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        sendToDlqMessages = this.brokerMeter.counterBuilder("rocketmq_send_to_dlq_messages_total").setDescription("Consumer send to DLQ messages").build();
    }

    private void initTransactionMetrics() {
        commitMessagesTotal = this.brokerMeter.counterBuilder("rocketmq_commit_messages_total").setDescription("Total number of commit messages").build();
        rollBackMessagesTotal = this.brokerMeter.counterBuilder("rocketmq_rollback_messages_total").setDescription("Total number of rollback messages").build();
        transactionFinishLatency = this.brokerMeter.histogramBuilder("rocketmq_finish_message_latency").setDescription("Transaction finish latency").ofLongs().setUnit("ms").build();
        halfMessages = this.brokerMeter.gaugeBuilder("rocketmq_half_messages").setDescription("Half messages of all topics").ofLongs().buildWithCallback(measurement -> this.brokerController.getTransactionalMessageService().getTransactionMetrics().getTransactionCounts().forEach((topic, metric) -> measurement.record(metric.getCount().get(), BrokerMetricsManager.newAttributesBuilder().put("topic", topic).build())));
    }

    private void initOtherMetrics() {
        RemotingMetricsManager.initMetrics((Meter)this.brokerMeter, BrokerMetricsManager::newAttributesBuilder);
        this.messageStore.initMetrics(this.brokerMeter, BrokerMetricsManager::newAttributesBuilder);
        PopMetricsManager.initMetrics(this.brokerMeter, this.brokerController, BrokerMetricsManager::newAttributesBuilder);
    }

    public void shutdown() {
        if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.OTLP_GRPC) {
            this.periodicMetricReader.forceFlush();
            this.periodicMetricReader.shutdown();
            this.metricExporter.shutdown();
        }
        if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.PROM) {
            this.prometheusHttpServer.forceFlush();
            this.prometheusHttpServer.shutdown();
        }
        if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.LOG) {
            this.periodicMetricReader.forceFlush();
            this.periodicMetricReader.shutdown();
            this.loggingMetricExporter.shutdown();
        }
    }
}

