/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 8715233786643882558L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LruCache.class.getName());
    private final int evictionWarningThrottle;
    private long evictionsSinceWarning = 0L;
    private Date lastEvictionWarning = new Date();
    private final int capacity;

    public LruCache(int cacheSize, int evictionWarningThrottle) {
        super(cacheSize, 0.75f, true);
        this.evictionWarningThrottle = evictionWarningThrottle;
        this.capacity = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.capacity) {
            this.evictionWarningIfNeeded();
            return true;
        }
        return false;
    }

    private void evictionWarningIfNeeded() {
        if (this.evictionWarningThrottle <= 0) {
            return;
        }
        ++this.evictionsSinceWarning;
        if (this.evictionsSinceWarning >= (long)this.evictionWarningThrottle) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There have been " + this.evictionsSinceWarning + " evictions from the cache since " + dateFormat.format(this.lastEvictionWarning));
            }
            this.evictionsSinceWarning = 0L;
            this.lastEvictionWarning = new Date();
        }
    }
}

