/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;
import org.apache.atlas.groovy.StatementListExpression;

public class ClosureExpression
extends AbstractGroovyExpression {
    private List<VariableDeclaration> vars = new ArrayList<VariableDeclaration>();
    private StatementListExpression body = new StatementListExpression();

    public ClosureExpression(String ... varNames) {
        this((GroovyExpression)null, varNames);
    }

    public ClosureExpression(GroovyExpression initialStmt, String ... varNames) {
        this(Arrays.asList(varNames), initialStmt);
    }

    public ClosureExpression(List<String> varNames, GroovyExpression initialStmt) {
        if (initialStmt != null) {
            this.body.addStatement(initialStmt);
        }
        for (String varName : varNames) {
            this.vars.add(new VariableDeclaration(varName));
        }
    }

    public ClosureExpression(GroovyExpression initialStmt, List<VariableDeclaration> varNames) {
        if (initialStmt != null) {
            this.body.addStatement(initialStmt);
        }
        this.vars.addAll(varNames);
    }

    public void addStatement(GroovyExpression expr) {
        this.body.addStatement(expr);
    }

    public void addStatements(List<GroovyExpression> exprs) {
        this.body.addStatements(exprs);
    }

    public void replaceStatement(int index, GroovyExpression newExpr) {
        this.body.replaceStatement(index, newExpr);
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        context.append("{");
        if (!this.vars.isEmpty()) {
            Iterator<VariableDeclaration> varIt = this.vars.iterator();
            while (varIt.hasNext()) {
                VariableDeclaration var = varIt.next();
                var.append(context);
                if (!varIt.hasNext()) continue;
                context.append(", ");
            }
            context.append("->");
        }
        this.body.generateGroovy(context);
        context.append("}");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.body);
    }

    public List<GroovyExpression> getStatements() {
        return this.body.getStatements();
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        assert (newChildren.size() == 1);
        return new ClosureExpression(newChildren.get(0), this.vars);
    }

    public static class VariableDeclaration {
        private String type;
        private String varName;

        public VariableDeclaration(String type, String varName) {
            this.type = type;
            this.varName = varName;
        }

        public VariableDeclaration(String varName) {
            this.varName = varName;
        }

        public void append(GroovyGenerationContext context) {
            if (this.type != null) {
                context.append(this.type);
                context.append(" ");
            }
            context.append(this.varName);
        }
    }
}

