/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutput;
import java.util.List;
import org.apache.atlas.hook.FailedMessagesLogger;
import org.apache.atlas.model.notification.AtlasNotificationMessage;
import org.apache.atlas.notification.AbstractNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.notification.spool.IndexManagement;
import org.apache.atlas.notification.spool.SpoolConfiguration;
import org.apache.atlas.notification.spool.SpoolUtils;
import org.apache.atlas.type.AtlasType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spooler
extends AbstractNotification {
    private static final Logger LOG = LoggerFactory.getLogger(Spooler.class);
    private final SpoolConfiguration configuration;
    private final IndexManagement indexManagement;
    private FailedMessagesLogger failedMessagesLogger;
    private boolean isDrain;

    public Spooler(SpoolConfiguration configuration, IndexManagement indexManagement) {
        this.configuration = configuration;
        this.indexManagement = indexManagement;
    }

    public void setFailedMessagesLogger(FailedMessagesLogger failedMessagesLogger) {
        this.failedMessagesLogger = failedMessagesLogger;
    }

    public void setDrain() {
        this.isDrain = true;
    }

    @Override
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers) {
        return null;
    }

    @Override
    public void sendInternal(NotificationInterface.NotificationType type, List<String> messages) {
        for (int i = 0; i < messages.size(); ++i) {
            AtlasNotificationMessage e = (AtlasNotificationMessage)AtlasType.fromV1Json((String)messages.get(i), AtlasNotificationMessage.class);
            e.setSpooled(true);
            messages.set(i, AtlasType.toV1Json((Object)e));
        }
        boolean ret = this.write(messages);
        if (this.failedMessagesLogger != null && !ret) {
            this.writeToFailedMessages(messages);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isReady(NotificationInterface.NotificationType type) {
        return true;
    }

    @VisibleForTesting
    boolean write(List<String> messages) {
        boolean ret;
        try {
            if (!this.getDrain()) {
                this.indexManagement.setSpoolWriteInProgress();
                ret = this.writeInternal(messages);
            } else {
                LOG.error("Spooler.write(source={}): called after stop is called! Write will not be performed!", (Object)this.configuration.getSourceName(), messages);
                ret = false;
            }
        }
        finally {
            this.indexManagement.resetSpoolWriteInProgress();
        }
        return ret;
    }

    private void writeToFailedMessages(List<String> messages) {
        if (this.failedMessagesLogger != null) {
            for (String message : messages) {
                this.failedMessagesLogger.log(message);
            }
        }
    }

    private boolean writeInternal(List<String> messages) {
        boolean ret = false;
        try {
            byte[] lineSeparatorBytes = SpoolUtils.getLineSeparator().getBytes("UTF-8");
            DataOutput pw = this.indexManagement.getSpoolWriter();
            for (String message : messages) {
                pw.write(message.getBytes("UTF-8"));
                pw.write(lineSeparatorBytes);
            }
            this.indexManagement.flushSpoolWriter();
            ret = true;
        }
        catch (Exception exception) {
            LOG.error("Spooler.writeInternal(source={}): error writing to file. messages={}", new Object[]{this.configuration.getSourceName(), messages, exception});
            ret = false;
        }
        return ret;
    }

    private boolean getDrain() {
        return this.isDrain;
    }
}

