/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.rest;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.kafka.KafkaNotification;
import org.apache.atlas.model.notification.AtlasNotificationBaseMessage;
import org.apache.atlas.notification.AbstractNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestNotification
extends AbstractNotification {
    private static final Logger LOG = LoggerFactory.getLogger(RestNotification.class);
    private static final int BATCH_MAX_LENGTH_BYTES = AtlasConfiguration.NOTIFICATION_REST_BODY_MAX_LENGTH_BYTES.getInt();
    private static final String ATLAS_ENDPOINT = "atlas.rest.address";
    private static final String BASIC_AUTH_USERNAME = "atlas.rest.basic.auth.username";
    private static final String BASIC_AUTH_PASSWORD = "atlas.rest.basic.auth.password";
    private static final String DEFAULT_ATLAS_URL = "http://localhost:31000/";
    private static final Map<NotificationInterface.NotificationType, String> PRODUCER_TOPIC_MAP = new HashMap<NotificationInterface.NotificationType, String>(){
        {
            this.put(NotificationInterface.NotificationType.HOOK, KafkaNotification.ATLAS_HOOK_TOPIC);
            this.put(NotificationInterface.NotificationType.ENTITIES, KafkaNotification.ATLAS_ENTITIES_TOPIC);
        }
    };
    @VisibleForTesting
    public AtlasClientV2 atlasClientV2;

    public RestNotification(Configuration configuration) throws AtlasException {
        this.setupAtlasClientV2(configuration);
    }

    private AtlasClientV2 setupAtlasClientV2(Configuration configuration) throws AtlasException {
        if (this.atlasClientV2 != null) {
            return this.atlasClientV2;
        }
        try {
            String[] atlasEndPoint = configuration.getStringArray(ATLAS_ENDPOINT);
            if (atlasEndPoint == null || atlasEndPoint.length == 0) {
                atlasEndPoint = new String[]{DEFAULT_ATLAS_URL};
            }
            if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
                String[] stringArray;
                String fileAuthUsername = configuration.getString(BASIC_AUTH_USERNAME, "admin");
                String fileAuthPassword = configuration.getString(BASIC_AUTH_PASSWORD, "admin123");
                if (fileAuthUsername == null || fileAuthPassword == null) {
                    stringArray = AuthenticationUtil.getBasicAuthenticationInput();
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = fileAuthUsername;
                    stringArray = stringArray2;
                    stringArray2[1] = fileAuthPassword;
                }
                String[] basicAuthUsernamePassword = stringArray;
                this.atlasClientV2 = new AtlasClientV2(atlasEndPoint, basicAuthUsernamePassword);
            } else {
                this.atlasClientV2 = new AtlasClientV2(atlasEndPoint);
            }
        }
        catch (AtlasException e) {
            throw new AtlasException((Throwable)e);
        }
        return this.atlasClientV2;
    }

    @Override
    public void sendInternal(NotificationInterface.NotificationType type, List<String> messages) throws NotificationException {
        String topic = PRODUCER_TOPIC_MAP.get((Object)type);
        List<List<String>> batches = this.getBatches(messages);
        int batchCounter = 0;
        try {
            for (List<String> batch : batches) {
                ++batchCounter;
                this.atlasClientV2.postNotificationToTopic(topic, batch);
            }
        }
        catch (AtlasServiceException e) {
            if (e.getMessage().contains(AtlasErrorCode.NOTIFICATION_EXCEPTION.getErrorCode())) {
                LOG.error("Sending notifications through REST interface failed starting from batch# {}", (Object)batchCounter);
                throw new NotificationException((Exception)((Object)e));
            }
            throw new RuntimeException(e);
        }
    }

    private List<List<String>> getBatches(List<String> messages) {
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        ArrayList<String> batch = new ArrayList<String>();
        int batchSize = 0;
        for (String message : messages) {
            byte[] msgBytes = AtlasNotificationBaseMessage.getBytesUtf8((String)message);
            if (batchSize > 0 && batchSize + msgBytes.length > BATCH_MAX_LENGTH_BYTES) {
                batches.add(batch);
                batch = new ArrayList();
                batchSize = 0;
            }
            batch.add(message);
            batchSize += msgBytes.length;
        }
        batches.add(batch);
        return batches;
    }

    @Override
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers) {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isReady(NotificationInterface.NotificationType type) {
        return true;
    }
}

