/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.kafka;

import com.google.common.annotations.VisibleForTesting;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.kafka.KafkaNotification;
import org.apache.atlas.notification.AbstractNotification;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.notification.rest.RestNotification;
import org.apache.atlas.notification.spool.AtlasFileSpool;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationProvider.class);
    @VisibleForTesting
    public static final String CONF_ATLAS_HOOK_SPOOL_ENABLED = "atlas.hook.spool.enabled";
    private static final String CONF_ATLAS_HOOK_SPOOL_DIR = "atlas.hook.spool.dir";
    private static final boolean CONF_ATLAS_HOOK_SPOOL_ENABLED_DEFAULT = false;
    private static NotificationInterface notificationProvider;

    public static NotificationInterface get() {
        if (notificationProvider == null) {
            try {
                Configuration conf = ApplicationProperties.get();
                String spoolDir = NotificationProvider.getSpoolDir(conf);
                AbstractNotification absNotifier = null;
                absNotifier = AtlasHook.isRESTNotificationEnabled ? new RestNotification(conf) : new KafkaNotification(conf);
                if (NotificationProvider.isSpoolingEnabled(conf) && StringUtils.isNotEmpty((String)spoolDir)) {
                    LOG.info("Notification spooling is enabled: spool directory={}", (Object)spoolDir);
                    conf.setProperty(CONF_ATLAS_HOOK_SPOOL_DIR, (Object)spoolDir);
                    notificationProvider = new AtlasFileSpool(conf, absNotifier);
                } else {
                    LOG.info("Notification spooling is not enabled");
                    notificationProvider = absNotifier;
                }
            }
            catch (AtlasException e) {
                throw new RuntimeException("Error while initializing Notification interface", e);
            }
        }
        LOG.debug("NotificationInterface of type {} is enabled", (Object)notificationProvider.getClass().getSimpleName());
        return notificationProvider;
    }

    private static boolean isSpoolingEnabled(Configuration configuration) {
        return configuration.getBoolean(CONF_ATLAS_HOOK_SPOOL_ENABLED, false);
    }

    private static String getSpoolDir(Configuration configuration) {
        return configuration.getString(CONF_ATLAS_HOOK_SPOOL_DIR);
    }
}

