/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasHdfsResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_HDFS_PATH = "hdfs_path";
    public static final String RANGER_TYPE_HDFS_PATH = "path";
    public static final String TAGSYNC_ATLAS_NAME_SERVICE_IDENTIFIER = ".nameservice.";
    public static final String ENTITY_TYPE_HDFS_CLUSTER_AND_NAME_SERVICE_SEPARATOR = "_";
    public static final String ENTITY_ATTRIBUTE_PATH = "path";
    public static final String ENTITY_ATTRIBUTE_CLUSTER_NAME = "clusterName";
    public static final String ENTITY_ATTRIBUTE_NAME_SERVICE_ID = "nameServiceId";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"hdfs_path"};

    public AtlasHdfsResourceMapper() {
        super("hdfs", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public String getRangerServiceName(String clusterName) {
        String ret = this.getCustomRangerServiceName(clusterName);
        if (StringUtils.isBlank((String)ret)) {
            ret = clusterName + ENTITY_TYPE_HDFS_CLUSTER_AND_NAME_SERVICE_SEPARATOR + "hadoop";
        }
        return ret;
    }

    private String getCustomRangerServiceNameForClusterAndNameService(String clusterName, String nameServiceId) {
        String ret = null;
        if (this.properties != null) {
            String propName = "ranger.tagsync.atlas." + this.componentName + ".instance." + clusterName + TAGSYNC_ATLAS_NAME_SERVICE_IDENTIFIER + nameServiceId + ".ranger.service";
            ret = this.properties.getProperty(propName);
        }
        if (ret == null) {
            ret = this.getRangerServiceName(clusterName) + ENTITY_TYPE_HDFS_CLUSTER_AND_NAME_SERVICE_SEPARATOR + nameServiceId;
        }
        return ret;
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        String nameServiceId = (String)entity.getAttributes().get(ENTITY_ATTRIBUTE_NAME_SERVICE_ID);
        String path = null;
        String clusterName = null;
        if (StringUtils.isNotEmpty((String)qualifiedName)) {
            path = this.getResourceNameFromQualifiedName(qualifiedName);
            clusterName = this.getClusterNameFromQualifiedName(qualifiedName);
        }
        if (StringUtils.isEmpty(path)) {
            path = (String)entity.getAttributes().get("path");
        }
        if (StringUtils.isEmpty((String)path)) {
            this.throwExceptionWithMessage("path not found in attribute 'qualifiedName' or 'path'");
        }
        if (StringUtils.isEmpty((String)clusterName)) {
            clusterName = (String)entity.getAttributes().get(ENTITY_ATTRIBUTE_CLUSTER_NAME);
        }
        if (StringUtils.isEmpty((String)clusterName)) {
            clusterName = this.defaultClusterName;
        }
        if (StringUtils.isEmpty((String)clusterName)) {
            this.throwExceptionWithMessage("clusterName not found in attribute 'qualifiedName' or 'clusterName'");
        }
        String entityGuid = entity.getGuid();
        String serviceName = StringUtils.isNotBlank((String)nameServiceId) ? this.getCustomRangerServiceNameForClusterAndNameService(clusterName, nameServiceId) : this.getRangerServiceName(clusterName);
        Boolean isExcludes = Boolean.FALSE;
        Boolean isRecursive = Boolean.TRUE;
        Path pathObj = new Path(path);
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        elements.put("path", new RangerPolicy.RangerPolicyResource(pathObj.toUri().getPath(), isExcludes, isRecursive));
        RangerServiceResource ret = new RangerServiceResource(entityGuid, serviceName, elements);
        return ret;
    }
}

