/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.locks.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.locks.ManagementLocks;
import com.microsoft.azure.management.locks.implementation.ManagementLockClientImpl;
import com.microsoft.azure.management.locks.implementation.ManagementLocksImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_3_0)
public final class AuthorizationManager
extends Manager<AuthorizationManager, ManagementLockClientImpl> {
    private ManagementLocks managementLocks;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static AuthorizationManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new AuthorizationManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).build(), subscriptionId);
    }

    public static AuthorizationManager authenticate(RestClient restClient, String subscriptionId) {
        return new AuthorizationManager(restClient, subscriptionId);
    }

    private AuthorizationManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ManagementLockClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public ManagementLocks managementLocks() {
        if (this.managementLocks == null) {
            this.managementLocks = new ManagementLocksImpl(this);
        }
        return this.managementLocks;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AuthorizationManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return AuthorizationManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AuthorizationManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

