/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.graphrbac.implementation.DomainInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DomainsInner {
    private DomainsService service;
    private GraphRbacManagementClientImpl client;

    public DomainsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (DomainsService)retrofit.create(DomainsService.class);
        this.client = client;
    }

    public List<DomainInner> list() {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<DomainInner>> listAsync(ServiceCallback<List<DomainInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<DomainInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<DomainInner>>, List<DomainInner>>(){

            public List<DomainInner> call(ServiceResponse<List<DomainInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DomainInner>>> listWithServiceResponseAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DomainInner>>>>(){

            public Observable<ServiceResponse<List<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<DomainInner> list(String filter) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<DomainInner>> listAsync(String filter, ServiceCallback<List<DomainInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(filter), serviceCallback);
    }

    public Observable<List<DomainInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<List<DomainInner>>, List<DomainInner>>(){

            public List<DomainInner> call(ServiceResponse<List<DomainInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DomainInner>>> listWithServiceResponseAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DomainInner>>>>(){

            public Observable<ServiceResponse<List<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DomainInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DomainInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainInner get(String domainName) {
        return (DomainInner)((ServiceResponse)this.getWithServiceResponseAsync(domainName).toBlocking().single()).body();
    }

    public ServiceFuture<DomainInner> getAsync(String domainName, ServiceCallback<DomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(domainName), serviceCallback);
    }

    public Observable<DomainInner> getAsync(String domainName) {
        return this.getWithServiceResponseAsync(domainName).map((Func1)new Func1<ServiceResponse<DomainInner>, DomainInner>(){

            public DomainInner call(ServiceResponse<DomainInner> response) {
                return (DomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainInner>> getWithServiceResponseAsync(String domainName) {
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(domainName, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainInner>>>(){

            public Observable<ServiceResponse<DomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DomainsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Domains list"})
        @GET(value="{tenantID}/domains")
        public Observable<Response<ResponseBody>> list(@Path(value="tenantID") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Domains get"})
        @GET(value="{tenantID}/domains/{domainName}")
        public Observable<Response<ResponseBody>> get(@Path(value="domainName") String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

