/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.messagesecurity.MessageSecurityHelper;
import java.io.IOException;
import java.util.Objects;

class JWEHeader {
    private String alg;
    private String kid;
    private String enc;

    JWEHeader() {
    }

    JWEHeader(String alg, String kid, String enc) {
        this.alg = alg;
        this.kid = kid;
        this.enc = enc;
    }

    public boolean equals(JWEHeader other) {
        return this.alg.equals(other.alg) && this.kid.equals(other.kid) && this.enc.equals(other.enc);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JWEHeader)) {
            return false;
        }
        return object == this || this.equals((JWEHeader)object);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.kid, this.enc);
    }

    public String serialize() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static JWEHeader deserialize(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JWEHeader)mapper.readValue(json, JWEHeader.class);
    }

    public static JWEHeader fromBase64String(String base64) throws IOException {
        String json = MessageSecurityHelper.base64UrltoString(base64);
        return JWEHeader.deserialize(json);
    }

    @JsonProperty(value="alg")
    public String alg() {
        return this.alg;
    }

    @JsonProperty(value="kid")
    public String kid() {
        return this.kid;
    }

    @JsonProperty(value="enc")
    public String enc() {
        return this.enc;
    }
}

