/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.servicebus.implementation.PageImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.SubscriptionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SubscriptionsInner {
    private SubscriptionsService service;
    private ServiceBusManagementClientImpl client;

    public SubscriptionsInner(Retrofit retrofit, ServiceBusManagementClientImpl client) {
        this.service = (SubscriptionsService)retrofit.create(SubscriptionsService.class);
        this.client = client;
    }

    public PagedList<SubscriptionInner> listByTopic(String resourceGroupName, String namespaceName, String topicName) {
        ServiceResponse response = (ServiceResponse)this.listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName).toBlocking().single();
        return new PagedList<SubscriptionInner>((Page)response.body()){

            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionsInner.this.listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubscriptionInner>> listByTopicAsync(String resourceGroupName, String namespaceName, String topicName, ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                return SubscriptionsInner.this.listByTopicNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionInner>> listByTopicAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.listByTopicWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).map((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>(){

            public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName).concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionsInner.this.listByTopicNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicSinglePageAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByTopic(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionsInner.this.listByTopicDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SubscriptionInner>> listByTopicDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SubscriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubscriptionInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        return (SubscriptionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters, ServiceCallback<SubscriptionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters), serviceCallback);
    }

    public Observable<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).map((Func1)new Func1<ServiceResponse<SubscriptionInner>, SubscriptionInner>(){

            public SubscriptionInner call(ServiceResponse<SubscriptionInner> response) {
                return (SubscriptionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubscriptionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionInner>>>(){

            public Observable<ServiceResponse<SubscriptionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubscriptionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SubscriptionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubscriptionInner get(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return (SubscriptionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).toBlocking().single()).body());
    }

    public ServiceFuture<SubscriptionInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, ServiceCallback<SubscriptionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName), serviceCallback);
    }

    public Observable<SubscriptionInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).map((Func1)new Func1<ServiceResponse<SubscriptionInner>, SubscriptionInner>(){

            public SubscriptionInner call(ServiceResponse<SubscriptionInner> response) {
                return (SubscriptionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubscriptionInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionInner>>>(){

            public Observable<ServiceResponse<SubscriptionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubscriptionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SubscriptionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubscriptionInner> listByTopicNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SubscriptionInner>((Page)response.body()){

            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionsInner.this.listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubscriptionInner>> listByTopicNextAsync(String nextPageLink, ServiceFuture<List<SubscriptionInner>> serviceFuture, ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByTopicNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                return SubscriptionsInner.this.listByTopicNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionInner>> listByTopicNextAsync(String nextPageLink) {
        return this.listByTopicNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>(){

            public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByTopicNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionsInner.this.listByTopicNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByTopicNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionsInner.this.listByTopicNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SubscriptionInner>> listByTopicNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SubscriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SubscriptionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions listByTopic"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions")
        public Observable<Response<ResponseBody>> listByTopic(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionName") String var4, @Path(value="subscriptionId") String var5, @Body SubscriptionInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions listByTopicNext"})
        @GET
        public Observable<Response<ResponseBody>> listByTopicNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

