/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SecurityAlertPolicyEmailAccountAdmins;
import com.microsoft.azure.management.sql.SecurityAlertPolicyState;
import com.microsoft.azure.management.sql.SecurityAlertPolicyUseServerDefault;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseThreatDetectionPolicy;
import com.microsoft.azure.management.sql.implementation.DatabaseSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlDatabaseThreatDetectionPolicyImpl
extends ExternalChildResourceImpl<SqlDatabaseThreatDetectionPolicy, DatabaseSecurityAlertPolicyInner, SqlDatabaseImpl, SqlDatabase>
implements SqlDatabaseThreatDetectionPolicy,
SqlDatabaseThreatDetectionPolicy.SqlDatabaseThreatDetectionPolicyDefinition,
SqlDatabaseThreatDetectionPolicy.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    protected SqlDatabaseThreatDetectionPolicyImpl(String name, SqlDatabaseImpl parent, DatabaseSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withLocation(parent.regionName());
    }

    public String name() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).name();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).id();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((DatabaseSecurityAlertPolicyInner)this.inner()).location());
    }

    @Override
    public String kind() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).kind();
    }

    @Override
    public SecurityAlertPolicyState currentState() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).state();
    }

    @Override
    public String disabledAlerts() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).disabledAlerts();
    }

    @Override
    public String emailAddresses() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).emailAddresses();
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).emailAccountAdmins() == SecurityAlertPolicyEmailAccountAdmins.ENABLED;
    }

    @Override
    public String storageEndpoint() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).retentionDays();
    }

    @Override
    public boolean isDefaultSecurityAlertPolicy() {
        return ((DatabaseSecurityAlertPolicyInner)this.inner()).useServerDefault() == SecurityAlertPolicyUseServerDefault.ENABLED;
    }

    protected Observable<DatabaseSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseThreatDetectionPolicies().getAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name());
    }

    public Observable<SqlDatabaseThreatDetectionPolicy> createResourceAsync() {
        final SqlDatabaseThreatDetectionPolicyImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseThreatDetectionPolicies().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), (DatabaseSecurityAlertPolicyInner)this.inner()).map((Func1)new Func1<DatabaseSecurityAlertPolicyInner, SqlDatabaseThreatDetectionPolicy>(){

            public SqlDatabaseThreatDetectionPolicy call(DatabaseSecurityAlertPolicyInner databaseSecurityAlertPolicyInner) {
                self.setInner(databaseSecurityAlertPolicyInner);
                return self;
            }
        });
    }

    public Observable<SqlDatabaseThreatDetectionPolicy> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public SqlDatabaseThreatDetectionPolicy.Update update() {
        super.prepareUpdate();
        return this;
    }

    public Observable<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyEnabled() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withState(SecurityAlertPolicyState.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyDisabled() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withState(SecurityAlertPolicyState.DISABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyNew() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withState(SecurityAlertPolicyState.NEW);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withDefaultSecurityAlertPolicy() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withUseServerDefault(SecurityAlertPolicyUseServerDefault.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageEndpoint(String storageEndpoint) {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(String alertsFilter) {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withDisabledAlerts(alertsFilter);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(String addresses) {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withEmailAddresses(addresses);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withRetentionDays(int retentionDays) {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withRetentionDays(retentionDays);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withoutEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)this.inner()).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.DISABLED);
        return this;
    }
}

