/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.sql.AutomaticTuningMode;
import com.microsoft.azure.management.sql.AutomaticTuningOptionModeDesired;
import com.microsoft.azure.management.sql.AutomaticTuningOptions;
import com.microsoft.azure.management.sql.SqlDatabaseAutomaticTuning;
import com.microsoft.azure.management.sql.implementation.DatabaseAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlDatabaseAutomaticTuningImpl
extends RefreshableWrapperImpl<DatabaseAutomaticTuningInner, SqlDatabaseAutomaticTuning>
implements SqlDatabaseAutomaticTuning,
SqlDatabaseAutomaticTuning.Update {
    protected String key;
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private Map<String, AutomaticTuningOptions> automaticTuningOptionsMap;

    SqlDatabaseAutomaticTuningImpl(SqlDatabaseImpl database, DatabaseAutomaticTuningInner innerObject) {
        this(database.resourceGroupName, database.sqlServerName, database.name(), innerObject, database.sqlServerManager);
    }

    SqlDatabaseAutomaticTuningImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, DatabaseAutomaticTuningInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
        this.key = UUID.randomUUID().toString();
        this.automaticTuningOptionsMap = new HashMap<String, AutomaticTuningOptions>();
    }

    @Override
    public AutomaticTuningMode desiredState() {
        return ((DatabaseAutomaticTuningInner)this.inner()).desiredState();
    }

    @Override
    public AutomaticTuningMode actualState() {
        return ((DatabaseAutomaticTuningInner)this.inner()).actualState();
    }

    @Override
    public Map<String, AutomaticTuningOptions> tuningOptions() {
        return Collections.unmodifiableMap(((DatabaseAutomaticTuningInner)this.inner()).options() != null ? ((DatabaseAutomaticTuningInner)this.inner()).options() : new HashMap());
    }

    @Override
    public SqlDatabaseAutomaticTuningImpl withAutomaticTuningMode(AutomaticTuningMode desiredState) {
        ((DatabaseAutomaticTuningInner)this.inner()).withDesiredState(desiredState);
        return this;
    }

    @Override
    public SqlDatabaseAutomaticTuningImpl withAutomaticTuningOption(String tuningOptionName, AutomaticTuningOptionModeDesired desiredState) {
        if (this.automaticTuningOptionsMap == null) {
            this.automaticTuningOptionsMap = new HashMap<String, AutomaticTuningOptions>();
        }
        this.automaticTuningOptionsMap.put(tuningOptionName, new AutomaticTuningOptions().withDesiredState(desiredState));
        return this;
    }

    @Override
    public SqlDatabaseAutomaticTuningImpl withAutomaticTuningOptions(Map<String, AutomaticTuningOptionModeDesired> tuningOptions) {
        if (tuningOptions != null) {
            for (Map.Entry<String, AutomaticTuningOptionModeDesired> option : tuningOptions.entrySet()) {
                this.withAutomaticTuningOption(option.getKey(), option.getValue());
            }
        }
        return this;
    }

    public SqlDatabaseAutomaticTuningImpl update() {
        return this;
    }

    protected Observable<DatabaseAutomaticTuningInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseAutomaticTunings().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName);
    }

    public SqlDatabaseAutomaticTuning apply() {
        return (SqlDatabaseAutomaticTuning)this.applyAsync().toBlocking().last();
    }

    public Observable<SqlDatabaseAutomaticTuning> applyAsync() {
        final SqlDatabaseAutomaticTuningImpl self = this;
        ((DatabaseAutomaticTuningInner)this.inner()).withOptions(this.automaticTuningOptionsMap);
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseAutomaticTunings().updateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, (DatabaseAutomaticTuningInner)this.inner()).map((Func1)new Func1<DatabaseAutomaticTuningInner, SqlDatabaseAutomaticTuning>(){

            public SqlDatabaseAutomaticTuning call(DatabaseAutomaticTuningInner databaseAutomaticTuningInner) {
                self.setInner(databaseAutomaticTuningInner);
                self.automaticTuningOptionsMap.clear();
                return self;
            }
        });
    }

    public ServiceFuture<SqlDatabaseAutomaticTuning> applyAsync(ServiceCallback<SqlDatabaseAutomaticTuning> callback) {
        return ServiceFuture.fromBody(this.applyAsync(), callback);
    }

    public String key() {
        return this.key;
    }
}

