/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.AppServicePlanInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class AppServicePlanImpl
extends GroupableResourceImpl<AppServicePlan, AppServicePlanInner, AppServicePlanImpl, AppServiceManager>
implements AppServicePlan,
AppServicePlan.Definition,
AppServicePlan.Update {
    AppServicePlanImpl(String name, AppServicePlanInner innerObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    public Observable<AppServicePlan> createResourceAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServicePlans().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServicePlanInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<AppServicePlanInner> getInnerAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServicePlans().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public int maxInstances() {
        return Utils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.inner())).maximumNumberOfWorkers());
    }

    @Override
    public int capacity() {
        return Utils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.inner())).sku().capacity());
    }

    @Override
    public boolean perSiteScaling() {
        return ((AppServicePlanInner)((Object)this.inner())).perSiteScaling();
    }

    @Override
    public int numberOfWebApps() {
        return Utils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.inner())).numberOfSites());
    }

    @Override
    public PricingTier pricingTier() {
        return PricingTier.fromSkuDescription(((AppServicePlanInner)((Object)this.inner())).sku());
    }

    @Override
    public OperatingSystem operatingSystem() {
        if (((AppServicePlanInner)((Object)this.inner())).kind().toLowerCase().contains("linux")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.WINDOWS;
    }

    @Override
    public AppServicePlanImpl withFreePricingTier() {
        return this.withPricingTier(PricingTier.FREE_F1);
    }

    @Override
    public AppServicePlanImpl withSharedPricingTier() {
        return this.withPricingTier(PricingTier.SHARED_D1);
    }

    @Override
    public AppServicePlanImpl withPricingTier(PricingTier pricingTier) {
        if (pricingTier == null) {
            throw new IllegalArgumentException("pricingTier == null");
        }
        ((AppServicePlanInner)((Object)this.inner())).withSku(pricingTier.toSkuDescription());
        return this;
    }

    @Override
    public AppServicePlanImpl withPerSiteScaling(boolean perSiteScaling) {
        ((AppServicePlanInner)((Object)this.inner())).withPerSiteScaling(perSiteScaling);
        return this;
    }

    @Override
    public AppServicePlanImpl withCapacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity is at least 1.");
        }
        ((AppServicePlanInner)((Object)this.inner())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public AppServicePlanImpl withOperatingSystem(OperatingSystem operatingSystem) {
        if (OperatingSystem.LINUX.equals((Object)operatingSystem)) {
            ((AppServicePlanInner)((Object)this.inner())).withReserved(true);
            ((AppServicePlanInner)((Object)this.inner())).withKind("linux");
        } else {
            ((AppServicePlanInner)((Object)this.inner())).withKind("app");
        }
        return this;
    }
}

