/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.CustomDomainParameters;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CustomDomainInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class CustomDomainsInner {
    private CustomDomainsService service;
    private CdnManagementClientImpl client;

    public CustomDomainsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (CustomDomainsService)retrofit.create(CustomDomainsService.class);
        this.client = client;
    }

    public PagedList<CustomDomainInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<CustomDomainInner>((Page)response.body()){

            public Page<CustomDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CustomDomainsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CustomDomainInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, ListOperationCallback<CustomDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(String nextPageLink) {
                return CustomDomainsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CustomDomainInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Page<CustomDomainInner>>, Page<CustomDomainInner>>(){

            public Page<CustomDomainInner> call(ServiceResponse<Page<CustomDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).concatMap((Func1)new Func1<ServiceResponse<Page<CustomDomainInner>>, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(ServiceResponse<Page<CustomDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CustomDomainsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CustomDomainsInner.this.listByEndpointDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CustomDomainInner>> listByEndpointDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CustomDomainInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CustomDomainInner get(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<CustomDomainInner> getAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    public Observable<CustomDomainInner> getAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>(){

            public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CustomDomainsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CustomDomainInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CustomDomainInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CustomDomainInner create(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return (CustomDomainInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).toBlocking().last()).body();
    }

    public ServiceFuture<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName), serviceCallback);
    }

    public Observable<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        CustomDomainParameters customDomainProperties = new CustomDomainParameters();
        customDomainProperties.withHostName(hostName);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CustomDomainInner>(){}.getType());
    }

    public CustomDomainInner beginCreate(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return (CustomDomainInner)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).toBlocking().single()).body();
    }

    public ServiceFuture<CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName), serviceCallback);
    }

    public Observable<CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        CustomDomainParameters customDomainProperties = new CustomDomainParameters();
        customDomainProperties.withHostName(hostName);
        return this.service.beginCreate(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>(){

            public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CustomDomainsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CustomDomainInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CustomDomainInner>(){}.getType()).register(201, new TypeToken<CustomDomainInner>(){}.getType()).register(202, new TypeToken<CustomDomainInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CustomDomainInner delete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().last()).body();
    }

    public ServiceFuture<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    public Observable<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<CustomDomainInner>(){}.getType());
    }

    public CustomDomainInner beginDelete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    public Observable<CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>(){

            public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CustomDomainsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CustomDomainInner> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<CustomDomainInner>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CustomDomainInner disableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((ServiceResponse)this.disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    public Observable<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> disableCustomHttpsWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.disableCustomHttps(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>(){

            public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CustomDomainsInner.this.disableCustomHttpsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CustomDomainInner> disableCustomHttpsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<CustomDomainInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CustomDomainInner enableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return (CustomDomainInner)((ServiceResponse)this.enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single()).body();
    }

    public ServiceFuture<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    public Observable<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return this.enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map((Func1)new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>(){

            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return (CustomDomainInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CustomDomainInner>> enableCustomHttpsWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.enableCustomHttps(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>(){

            public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CustomDomainsInner.this.enableCustomHttpsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CustomDomainInner> enableCustomHttpsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<CustomDomainInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<CustomDomainInner> listByEndpointNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CustomDomainInner>((Page)response.body()){

            public Page<CustomDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CustomDomainsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CustomDomainInner>> listByEndpointNextAsync(String nextPageLink, ServiceFuture<List<CustomDomainInner>> serviceFuture, ListOperationCallback<CustomDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(String nextPageLink) {
                return CustomDomainsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CustomDomainInner>> listByEndpointNextAsync(String nextPageLink) {
        return this.listByEndpointNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CustomDomainInner>>, Page<CustomDomainInner>>(){

            public Page<CustomDomainInner> call(ServiceResponse<Page<CustomDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByEndpointNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CustomDomainInner>>, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(ServiceResponse<Page<CustomDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CustomDomainsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CustomDomainInner>>>>(){

            public Observable<ServiceResponse<Page<CustomDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CustomDomainsInner.this.listByEndpointNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CustomDomainInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CustomDomainInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface CustomDomainsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains listByEndpoint"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains")
        public Observable<Response<ResponseBody>> listByEndpoint(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body CustomDomainParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body CustomDomainParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains disableCustomHttps"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/disableCustomHttps")
        public Observable<Response<ResponseBody>> disableCustomHttps(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains enableCustomHttps"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/enableCustomHttps")
        public Observable<Response<ResponseBody>> enableCustomHttps(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="customDomainName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains listByEndpointNext"})
        @GET
        public Observable<Response<ResponseBody>> listByEndpointNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

