/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.BgpSettings;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.VirtualNetworkGateway;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnection;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnections;
import com.microsoft.azure.management.network.VirtualNetworkGatewayIPConfiguration;
import com.microsoft.azure.management.network.VirtualNetworkGatewaySku;
import com.microsoft.azure.management.network.VirtualNetworkGatewaySkuName;
import com.microsoft.azure.management.network.VirtualNetworkGatewaySkuTier;
import com.microsoft.azure.management.network.VirtualNetworkGatewayType;
import com.microsoft.azure.management.network.VpnClientConfiguration;
import com.microsoft.azure.management.network.VpnClientParameters;
import com.microsoft.azure.management.network.VpnType;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.PointToSiteConfigurationImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionListEntityInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionsImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayIPConfigurationImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayInner;
import com.microsoft.azure.management.network.model.GroupableParentResourceWithTagsImpl;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VirtualNetworkGatewayImpl
extends GroupableParentResourceWithTagsImpl<VirtualNetworkGateway, VirtualNetworkGatewayInner, VirtualNetworkGatewayImpl, NetworkManager>
implements VirtualNetworkGateway,
VirtualNetworkGateway.Definition,
VirtualNetworkGateway.Update {
    private static final String GATEWAY_SUBNET = "GatewaySubnet";
    private Map<String, VirtualNetworkGatewayIPConfiguration> ipConfigs;
    private VirtualNetworkGatewayConnections connections;
    private Creatable<Network> creatableNetwork;
    private Creatable<PublicIPAddress> creatablePip;
    private final PagedListConverter<VirtualNetworkGatewayConnectionListEntityInner, VirtualNetworkGatewayConnection> connectionsConverter = new PagedListConverter<VirtualNetworkGatewayConnectionListEntityInner, VirtualNetworkGatewayConnection>(){

        public Observable<VirtualNetworkGatewayConnection> typeConvertAsync(VirtualNetworkGatewayConnectionListEntityInner inner) {
            return Observable.just((Object)((VirtualNetworkGatewayConnection)VirtualNetworkGatewayImpl.this.connections().getById(inner.id())));
        }
    };

    VirtualNetworkGatewayImpl(String name, VirtualNetworkGatewayInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    public VirtualNetworkGatewayImpl withExpressRoute() {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withGatewayType(VirtualNetworkGatewayType.EXPRESS_ROUTE);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withRouteBasedVpn() {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withGatewayType(VirtualNetworkGatewayType.VPN);
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withVpnType(VpnType.ROUTE_BASED);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withPolicyBasedVpn() {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withGatewayType(VirtualNetworkGatewayType.VPN);
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withVpnType(VpnType.POLICY_BASED);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withSku(VirtualNetworkGatewaySkuName skuName) {
        VirtualNetworkGatewaySku sku = new VirtualNetworkGatewaySku().withName(skuName).withTier(VirtualNetworkGatewaySkuTier.fromString(skuName.toString()));
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withSku(sku);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(Creatable<Network> creatable) {
        this.creatableNetwork = creatable;
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(String name, String addressSpace, String subnetAddressSpaceCidr) {
        Network.DefinitionStages.WithGroup definitionWithGroup = (Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)((NetworkManager)this.manager()).networks().define(name)).withRegion(this.regionName());
        Network.DefinitionStages.WithCreate definitionAfterGroup = this.newGroup() != null ? (Network.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(this.newGroup()) : (Network.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        Network.DefinitionStages.WithCreateAndSubnet network = definitionAfterGroup.withAddressSpace(addressSpace).withSubnet(GATEWAY_SUBNET, subnetAddressSpaceCidr);
        return this.withNewNetwork(network);
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(String addressSpaceCidr, String subnetAddressSpaceCidr) {
        this.withNewNetwork(SdkContext.randomResourceName((String)"vnet", (int)8), addressSpaceCidr, subnetAddressSpaceCidr);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingNetwork(Network network) {
        this.ensureDefaultIPConfig().withExistingSubnet(network, GATEWAY_SUBNET);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        this.ensureDefaultIPConfig().withExistingPublicIPAddress(publicIPAddress);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingPublicIPAddress(String resourceId) {
        this.ensureDefaultIPConfig().withExistingPublicIPAddress(resourceId);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        this.creatablePip = creatable;
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewPublicIPAddress() {
        String pipName = SdkContext.randomResourceName((String)"pip", (int)9);
        this.creatablePip = (Creatable)((PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIPAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withoutBgp() {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withBgpSettings(null);
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withEnableBgp(false);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withBgp(long asn, String bgpPeeringAddress) {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withEnableBgp(true);
        this.ensureBgpSettings().withAsn(asn).withBgpPeeringAddress(bgpPeeringAddress);
        return this;
    }

    void attachPointToSiteConfiguration(PointToSiteConfigurationImpl pointToSiteConfiguration) {
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withVpnClientConfiguration((VpnClientConfiguration)pointToSiteConfiguration.inner());
    }

    @Override
    public void reset() {
        this.resetAsync().await();
    }

    @Override
    public Completable resetAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().resetAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<VirtualNetworkGatewayInner, Void>(){

            public Void call(VirtualNetworkGatewayInner inner) {
                VirtualNetworkGatewayImpl.this.setInner((Object)inner);
                return null;
            }
        }).toCompletable();
    }

    @Override
    public PagedList<VirtualNetworkGatewayConnection> listConnections() {
        return this.wrapConnectionsList(((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().listConnections(this.resourceGroupName(), this.name()));
    }

    private PagedList<VirtualNetworkGatewayConnection> wrapConnectionsList(PagedList<VirtualNetworkGatewayConnectionListEntityInner> connectionListEntityInners) {
        return this.connectionsConverter.convert(connectionListEntityInners);
    }

    @Override
    public Observable<VirtualNetworkGatewayConnection> listConnectionsAsync() {
        return ReadableWrappersImpl.convertPageToInnerAsync(((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().listConnectionsAsync(this.resourceGroupName(), this.name())).map((Func1)new Func1<VirtualNetworkGatewayConnectionListEntityInner, VirtualNetworkGatewayConnection>(){

            public VirtualNetworkGatewayConnection call(VirtualNetworkGatewayConnectionListEntityInner connectionInner) {
                return (VirtualNetworkGatewayConnection)VirtualNetworkGatewayImpl.this.connections().getById(connectionInner.id());
            }
        });
    }

    @Override
    public String generateVpnProfile() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().generateVpnProfile(this.resourceGroupName(), this.name(), new VpnClientParameters());
    }

    @Override
    public Observable<String> generateVpnProfileAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().generateVpnProfileAsync(this.resourceGroupName(), this.name(), new VpnClientParameters());
    }

    @Override
    protected Observable<VirtualNetworkGatewayInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().updateTagsAsync(this.resourceGroupName(), this.name(), ((VirtualNetworkGatewayInner)((Object)this.inner())).getTags());
    }

    @Override
    public VirtualNetworkGatewayConnections connections() {
        if (this.connections == null) {
            this.connections = new VirtualNetworkGatewayConnectionsImpl(this);
        }
        return this.connections;
    }

    @Override
    public VirtualNetworkGatewayType gatewayType() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).gatewayType();
    }

    @Override
    public VpnType vpnType() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).vpnType();
    }

    @Override
    public boolean isBgpEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayInner)((Object)this.inner())).enableBgp());
    }

    @Override
    public boolean activeActive() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayInner)((Object)this.inner())).activeActive());
    }

    @Override
    public String gatewayDefaultSiteResourceId() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).gatewayDefaultSite() == null ? null : ((VirtualNetworkGatewayInner)((Object)this.inner())).gatewayDefaultSite().id();
    }

    @Override
    public VirtualNetworkGatewaySku sku() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).sku();
    }

    @Override
    public VpnClientConfiguration vpnClientConfiguration() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).vpnClientConfiguration();
    }

    @Override
    public BgpSettings bgpSettings() {
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).bgpSettings();
    }

    @Override
    public Collection<VirtualNetworkGatewayIPConfiguration> ipConfigurations() {
        return Collections.unmodifiableCollection(this.ipConfigs.values());
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    protected void initializeChildrenFromInner() {
        this.initializeIPConfigsFromInner();
    }

    public Observable<VirtualNetworkGateway> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<VirtualNetworkGateway, VirtualNetworkGateway>(){

            public VirtualNetworkGateway call(VirtualNetworkGateway virtualNetworkGateway) {
                VirtualNetworkGatewayImpl impl = (VirtualNetworkGatewayImpl)virtualNetworkGateway;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<VirtualNetworkGatewayInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworkGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    VirtualNetworkGatewayImpl withConfig(VirtualNetworkGatewayIPConfigurationImpl config) {
        if (config != null) {
            this.ipConfigs.put(config.name(), config);
        }
        return this;
    }

    private VirtualNetworkGatewayIPConfigurationImpl defineIPConfiguration(String name) {
        VirtualNetworkGatewayIPConfiguration ipConfig = this.ipConfigs.get(name);
        if (ipConfig == null) {
            VirtualNetworkGatewayIPConfigurationInner inner = new VirtualNetworkGatewayIPConfigurationInner().withName(name);
            return new VirtualNetworkGatewayIPConfigurationImpl(inner, this);
        }
        return (VirtualNetworkGatewayIPConfigurationImpl)ipConfig;
    }

    private void initializeIPConfigsFromInner() {
        this.ipConfigs = new TreeMap<String, VirtualNetworkGatewayIPConfiguration>();
        List<VirtualNetworkGatewayIPConfigurationInner> inners = ((VirtualNetworkGatewayInner)((Object)this.inner())).ipConfigurations();
        if (inners != null) {
            for (VirtualNetworkGatewayIPConfigurationInner inner : inners) {
                VirtualNetworkGatewayIPConfigurationImpl config = new VirtualNetworkGatewayIPConfigurationImpl(inner, this);
                this.ipConfigs.put(inner.name(), config);
            }
        }
    }

    protected void beforeCreating() {
        this.ensureDefaultIPConfig();
        ((VirtualNetworkGatewayInner)((Object)this.inner())).withIpConfigurations(this.innersFromWrappers(this.ipConfigs.values()));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    private BgpSettings ensureBgpSettings() {
        if (((VirtualNetworkGatewayInner)((Object)this.inner())).bgpSettings() == null) {
            ((VirtualNetworkGatewayInner)((Object)this.inner())).withBgpSettings(new BgpSettings());
        }
        return ((VirtualNetworkGatewayInner)((Object)this.inner())).bgpSettings();
    }

    private VirtualNetworkGatewayIPConfigurationImpl ensureDefaultIPConfig() {
        VirtualNetworkGatewayIPConfigurationImpl ipConfig = (VirtualNetworkGatewayIPConfigurationImpl)this.defaultIPConfiguration();
        if (ipConfig == null) {
            String name = SdkContext.randomResourceName((String)"ipcfg", (int)11);
            ipConfig = this.defineIPConfiguration(name);
            ipConfig.attach();
        }
        return ipConfig;
    }

    private Creatable<PublicIPAddress> ensureDefaultPipDefinition() {
        if (this.creatablePip == null) {
            String pipName = SdkContext.randomResourceName((String)"pip", (int)9);
            this.creatablePip = (Creatable)((PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIPAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        }
        return this.creatablePip;
    }

    VirtualNetworkGatewayIPConfiguration defaultIPConfiguration() {
        if (this.ipConfigs.size() == 1) {
            return this.ipConfigs.values().iterator().next();
        }
        return null;
    }

    protected Observable<VirtualNetworkGatewayInner> createInner() {
        final VirtualNetworkGatewayIPConfigurationImpl defaultIPConfig = this.ensureDefaultIPConfig();
        Observable pipObservable = defaultIPConfig != null && defaultIPConfig.publicIPAddressId() == null ? Utils.rootResource((Observable)this.ensureDefaultPipDefinition().createAsync()).map((Func1)new Func1<PublicIPAddress, Resource>(){

            public Resource call(PublicIPAddress publicIPAddress) {
                defaultIPConfig.withExistingPublicIPAddress(publicIPAddress);
                return publicIPAddress;
            }
        }) : Observable.empty();
        Observable networkObservable = defaultIPConfig.subnetName() != null ? Observable.empty() : Utils.rootResource((Observable)this.creatableNetwork.createAsync()).map((Func1)new Func1<Network, Resource>(){

            public Resource call(Network network) {
                defaultIPConfig.withExistingSubnet(network, VirtualNetworkGatewayImpl.GATEWAY_SUBNET);
                return network;
            }
        });
        return Observable.merge((Observable)networkObservable, (Observable)pipObservable).defaultIfEmpty(null).last().flatMap((Func1)new Func1<Resource, Observable<VirtualNetworkGatewayInner>>(){

            public Observable<VirtualNetworkGatewayInner> call(Resource resource) {
                return ((NetworkManagementClientImpl)((Object)((NetworkManager)VirtualNetworkGatewayImpl.this.manager()).inner())).virtualNetworkGateways().createOrUpdateAsync(VirtualNetworkGatewayImpl.this.resourceGroupName(), VirtualNetworkGatewayImpl.this.name(), (VirtualNetworkGatewayInner)((Object)VirtualNetworkGatewayImpl.this.inner()));
            }
        });
    }

    public PointToSiteConfigurationImpl definePointToSiteConfiguration() {
        return new PointToSiteConfigurationImpl(new VpnClientConfiguration(), this);
    }

    @Override
    public PointToSiteConfigurationImpl updatePointToSiteConfiguration() {
        return new PointToSiteConfigurationImpl(((VirtualNetworkGatewayInner)((Object)this.inner())).vpnClientConfiguration(), this);
    }
}

