/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;

@LangDefinition
class LoadBalancerInboundNatRuleImpl
extends ChildResourceImpl<InboundNatRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerInboundNatRule,
LoadBalancerInboundNatRule.Definition<LoadBalancer.DefinitionStages.WithCreateAndInboundNatRule>,
LoadBalancerInboundNatRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerInboundNatRule.Update {
    LoadBalancerInboundNatRuleImpl(InboundNatRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((InboundNatRuleInner)((Object)this.inner())).name();
    }

    @Override
    public String backendNicIPConfigurationName() {
        if (((InboundNatRuleInner)((Object)this.inner())).backendIPConfiguration() == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)((InboundNatRuleInner)((Object)this.inner())).backendIPConfiguration().id());
    }

    @Override
    public int backendPort() {
        return Utils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.inner())).backendPort());
    }

    @Override
    public String backendNetworkInterfaceId() {
        if (((InboundNatRuleInner)((Object)this.inner())).backendIPConfiguration() == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)((InboundNatRuleInner)((Object)this.inner())).backendIPConfiguration().id());
    }

    @Override
    public TransportProtocol protocol() {
        return ((InboundNatRuleInner)((Object)this.inner())).protocol();
    }

    @Override
    public int frontendPort() {
        return Utils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.inner())).frontendPort());
    }

    @Override
    public boolean floatingIPEnabled() {
        return ((InboundNatRuleInner)((Object)this.inner())).enableFloatingIP();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        return ((LoadBalancerImpl)this.parent()).frontends().get(ResourceUtils.nameFromResourceId((String)((InboundNatRuleInner)((Object)this.inner())).frontendIPConfiguration().id()));
    }

    @Override
    public int idleTimeoutInMinutes() {
        return Utils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.inner())).idleTimeoutInMinutes());
    }

    @Override
    public LoadBalancerInboundNatRuleImpl toBackendPort(int port) {
        ((InboundNatRuleInner)((Object)this.inner())).withBackendPort(port);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIPEnabled() {
        return this.withFloatingIP(true);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIPDisabled() {
        return this.withFloatingIP(false);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIP(boolean enabled) {
        ((InboundNatRuleInner)((Object)this.inner())).withEnableFloatingIP(enabled);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromFrontendPort(int port) {
        ((InboundNatRuleInner)((Object)this.inner())).withFrontendPort(port);
        if (this.backendPort() == 0) {
            return this.toBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((InboundNatRuleInner)((Object)this.inner())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withProtocol(TransportProtocol protocol) {
        ((InboundNatRuleInner)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((InboundNatRuleInner)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        }
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withInboundNatRule(this);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        this.fromFrontend(frontendName);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress(Creatable<PublicIPAddress> pipDefinition) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        this.fromFrontend(frontendName);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress() {
        String dnsLabel = SdkContext.randomResourceName((String)"fe", (int)20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }
}

