/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCrossConnection;
import com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeering;
import com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings;
import com.microsoft.azure.management.network.ExpressRoutePeeringType;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringsInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ExpressRouteCrossConnectionPeeringsImpl
extends IndependentChildrenImpl<ExpressRouteCrossConnectionPeering, ExpressRouteCrossConnectionPeeringImpl, ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeeringsInner, NetworkManager, ExpressRouteCrossConnection>
implements ExpressRouteCrossConnectionPeerings {
    private final ExpressRouteCrossConnectionImpl parent;

    ExpressRouteCrossConnectionPeeringsImpl(ExpressRouteCrossConnectionImpl parent) {
        super((Object)((NetworkManagementClientImpl)((Object)((NetworkManager)parent.manager()).inner())).expressRouteCrossConnectionPeerings(), parent.manager());
        this.parent = parent;
    }

    public final PagedList<ExpressRouteCrossConnectionPeering> list() {
        return new PagedListConverter<ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeering>(){

            public Observable<ExpressRouteCrossConnectionPeering> typeConvertAsync(ExpressRouteCrossConnectionPeeringInner inner) {
                return Observable.just((Object)ExpressRouteCrossConnectionPeeringsImpl.this.wrapModel(inner));
            }
        }.convert(ReadableWrappersImpl.convertToPagedList(((ExpressRouteCrossConnectionPeeringsInner)this.inner()).list(this.parent.resourceGroupName(), this.parent.name())));
    }

    public Observable<ExpressRouteCrossConnectionPeering> listAsync() {
        return this.wrapPageAsync(((ExpressRouteCrossConnectionPeeringsInner)this.inner()).listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected ExpressRouteCrossConnectionPeeringImpl wrapModel(String name) {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.fromString(name));
    }

    protected ExpressRouteCrossConnectionPeeringImpl wrapModel(ExpressRouteCrossConnectionPeeringInner inner) {
        return inner == null ? null : new ExpressRouteCrossConnectionPeeringImpl(this.parent, inner, inner.peeringType());
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl defineAzurePrivatePeering() {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.AZURE_PRIVATE_PEERING);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl defineMicrosoftPeering() {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.MICROSOFT_PEERING);
    }

    public Observable<ExpressRouteCrossConnectionPeering> getByNameAsync(String name) {
        return ((ExpressRouteCrossConnectionPeeringsInner)this.inner()).getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map((Func1)new Func1<ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeering>(){

            public ExpressRouteCrossConnectionPeering call(ExpressRouteCrossConnectionPeeringInner inner) {
                return ExpressRouteCrossConnectionPeeringsImpl.this.wrapModel(inner);
            }
        });
    }

    public ExpressRouteCrossConnectionPeering getByName(String name) {
        return (ExpressRouteCrossConnectionPeering)this.getByNameAsync(name).toBlocking().last();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((ExpressRouteCrossConnectionPeeringsInner)this.inner()).deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ExpressRouteCrossConnection parent() {
        return this.parent;
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((ExpressRouteCrossConnectionPeeringsInner)this.inner()).deleteAsync(groupName, parentName, name).map((Func1)new Func1<Void, Void>(){

            public Void call(Void result) {
                ExpressRouteCrossConnectionPeeringsImpl.this.parent.refresh();
                return result;
            }
        }).toCompletable();
    }

    public Observable<ExpressRouteCrossConnectionPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((ExpressRouteCrossConnectionPeeringsInner)this.inner()).getAsync(resourceGroup, parentName, name).map((Func1)new Func1<ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeering>(){

            public ExpressRouteCrossConnectionPeering call(ExpressRouteCrossConnectionPeeringInner inner) {
                return ExpressRouteCrossConnectionPeeringsImpl.this.wrapModel(inner);
            }
        });
    }

    public PagedList<ExpressRouteCrossConnectionPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((ExpressRouteCrossConnectionPeeringsInner)this.inner()).list(resourceGroupName, parentName));
    }
}

