/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.Route;
import com.microsoft.azure.management.network.RouteNextHopType;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.RouteTableInner;
import com.microsoft.azure.management.network.model.HasAssociatedSubnets;
import com.microsoft.azure.management.network.model.UpdatableWithTags;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
public interface RouteTable
extends GroupableResource<NetworkManager, RouteTableInner>,
Refreshable<RouteTable>,
Updatable<Update>,
UpdatableWithTags<RouteTable>,
HasAssociatedSubnets {
    public Map<String, Route> routes();

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public boolean isBgpRoutePropagationDisabled();

    public static interface Update
    extends Appliable<RouteTable>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithRoute,
    UpdateStages.WithBgpRoutePropagation {
    }

    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_10_0)
        public static interface WithBgpRoutePropagation {
            public Update withDisableBgpRoutePropagation();

            public Update withEnableBgpRoutePropagation();
        }

        public static interface WithRoute {
            public Update withRoute(String var1, RouteNextHopType var2);

            public Update withRouteViaVirtualAppliance(String var1, String var2);

            public Route.UpdateDefinitionStages.Blank<Update> defineRoute(String var1);

            public Update withoutRoute(String var1);

            public Route.Update updateRoute(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<RouteTable>,
        Resource.DefinitionWithTags<WithCreate>,
        WithRoute,
        WithBgpRoutePropagation {
        }

        @Beta(value=Beta.SinceVersion.V1_10_0)
        public static interface WithBgpRoutePropagation {
            public WithCreate withDisableBgpRoutePropagation();
        }

        public static interface WithRoute {
            public Route.DefinitionStages.Blank<WithCreate> defineRoute(String var1);

            public WithCreate withRoute(String var1, RouteNextHopType var2);

            public WithCreate withRouteViaVirtualAppliance(String var1, String var2);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

