/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuitSku;
import com.microsoft.azure.management.network.ExpressRouteCircuitSkuFamily;
import com.microsoft.azure.management.network.ExpressRouteCircuitSkuTier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@LangDefinition
@Beta(value=Beta.SinceVersion.V1_4_0)
public class ExpressRouteCircuitSkuType {
    private static final Map<String, ExpressRouteCircuitSkuType> VALUES_BY_NAME = new HashMap<String, ExpressRouteCircuitSkuType>();
    public static final ExpressRouteCircuitSkuType STANDARD_METEREDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.STANDARD, ExpressRouteCircuitSkuFamily.METERED_DATA);
    public static final ExpressRouteCircuitSkuType STANDARD_UNLIMITEDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.STANDARD, ExpressRouteCircuitSkuFamily.UNLIMITED_DATA);
    public static final ExpressRouteCircuitSkuType PREMIUM_METEREDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.PREMIUM, ExpressRouteCircuitSkuFamily.METERED_DATA);
    public static final ExpressRouteCircuitSkuType PREMIUM_UNLIMITEDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.PREMIUM, ExpressRouteCircuitSkuFamily.UNLIMITED_DATA);
    private final ExpressRouteCircuitSku sku;
    private final String value;

    public static ExpressRouteCircuitSkuType[] values() {
        Collection<ExpressRouteCircuitSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new ExpressRouteCircuitSkuType[valuesCollection.size()]);
    }

    public ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier skuTier, ExpressRouteCircuitSkuFamily skuFamily) {
        this(new ExpressRouteCircuitSku().withName((skuTier == null ? "" : skuTier.toString()) + "_" + (skuFamily == null ? "" : skuFamily.toString())).withTier(skuTier).withFamily(skuFamily));
    }

    public ExpressRouteCircuitSkuType(ExpressRouteCircuitSku sku) {
        this.sku = ExpressRouteCircuitSkuType.createCopy(sku);
        this.value = this.sku.name();
        VALUES_BY_NAME.put(this.value.toLowerCase(), this);
    }

    public static ExpressRouteCircuitSkuType fromSku(ExpressRouteCircuitSku sku) {
        if (sku == null) {
            return null;
        }
        String nameToLookFor = sku.name();
        ExpressRouteCircuitSkuType result = VALUES_BY_NAME.get(nameToLookFor.toLowerCase());
        if (result != null) {
            return result;
        }
        return new ExpressRouteCircuitSkuType(sku);
    }

    public ExpressRouteCircuitSku sku() {
        return ExpressRouteCircuitSkuType.createCopy(this.sku);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        String value = this.toString();
        if (!(obj instanceof ExpressRouteCircuitSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (value == null) {
            return ((ExpressRouteCircuitSkuType)obj).value == null;
        }
        return value.equalsIgnoreCase(((ExpressRouteCircuitSkuType)obj).value.toLowerCase());
    }

    private static ExpressRouteCircuitSku createCopy(ExpressRouteCircuitSku sku) {
        return new ExpressRouteCircuitSku().withName(sku.name()).withTier(sku.tier()).withFamily(sku.family());
    }
}

