/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerTagForEval
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RangerTagForEval.class);
    private String type;
    private Map<String, String> attributes;
    private Map<String, Object> options;
    private RangerPolicyResourceMatcher.MatchType matchType = RangerPolicyResourceMatcher.MatchType.SELF;
    @JsonIgnore
    private List<RangerValiditySchedule> validityPeriods;
    @JsonIgnore
    private transient List<RangerValidityScheduleEvaluator> validityPeriodEvaluators;

    private RangerTagForEval() {
    }

    public RangerTagForEval(RangerTag tag, RangerPolicyResourceMatcher.MatchType matchType) {
        this.type = tag.getType();
        this.attributes = tag.getAttributes() != null ? tag.getAttributes() : Collections.emptyMap();
        this.options = tag.getOptions() != null ? tag.getOptions() : Collections.emptyMap();
        this.matchType = matchType;
        this.validityPeriods = tag.getValidityPeriods() != null ? tag.getValidityPeriods() : Collections.emptyList();
        this.validityPeriodEvaluators = this.createValidityPeriodEvaluators();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public RangerPolicyResourceMatcher.MatchType getMatchType() {
        return this.matchType;
    }

    public List<RangerValiditySchedule> getValidityPeriods() {
        return this.validityPeriods;
    }

    public boolean isApplicable(Date accessTime) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagForEval.isApplicable(type=" + this.type + ", " + accessTime + ")");
        }
        boolean ret = false;
        List<RangerValidityScheduleEvaluator> validityPeriodEvaluators = this.validityPeriodEvaluators;
        if (MapUtils.isNotEmpty(this.options) && CollectionUtils.isEmpty(validityPeriodEvaluators)) {
            Object value = this.getOption("TAG_VALIDITY_PERIODS");
            if (value != null && value instanceof String) {
                this.validityPeriods = JsonUtils.jsonToRangerValiditySchedule((String)value);
                validityPeriodEvaluators = this.createValidityPeriodEvaluators();
            } else {
                validityPeriodEvaluators = Collections.emptyList();
            }
            this.validityPeriodEvaluators = validityPeriodEvaluators;
        }
        if (accessTime != null && CollectionUtils.isNotEmpty(validityPeriodEvaluators)) {
            for (RangerValidityScheduleEvaluator evaluator : validityPeriodEvaluators) {
                if (!evaluator.isApplicable(accessTime.getTime())) continue;
                ret = true;
                break;
            }
        } else {
            ret = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagForEval.isApplicable(type=" + this.type + ", " + accessTime + ") : " + ret);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerTagForEval={ ");
        sb.append("type=").append(this.type);
        sb.append(", attributes={ ");
        if (this.attributes != null) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                sb.append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\", ");
            }
        }
        sb.append(" }");
        sb.append(", matchType=").append((Object)this.matchType);
        if (this.options != null) {
            sb.append(", options={").append(this.options).append("}");
        }
        if (this.validityPeriods != null) {
            sb.append(", validityPeriods=").append(this.validityPeriods);
        }
        sb.append(" }");
        return sb;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.matchType == null ? 0 : this.matchType.hashCode());
        result = 31 * result + (this.validityPeriods == null ? 0 : this.validityPeriods.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangerTagForEval other = (RangerTagForEval)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.matchType == null ? other.matchType != null : !this.matchType.equals((Object)other.matchType)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        return !(this.validityPeriods == null ? other.validityPeriods != null : !this.validityPeriods.equals(other.validityPeriods));
    }

    private Object getOption(String name) {
        return this.options != null ? this.options.get(name) : null;
    }

    private List<RangerValidityScheduleEvaluator> createValidityPeriodEvaluators() {
        List<RangerValidityScheduleEvaluator> ret;
        if (CollectionUtils.isNotEmpty(this.validityPeriods)) {
            ret = new ArrayList();
            for (RangerValiditySchedule schedule : this.validityPeriods) {
                ret.add(new RangerValidityScheduleEvaluator(schedule));
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }
}

