/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSAuditLogger;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleKMSAuditLogger
implements KMSAuditLogger {
    private final Logger auditLog = LoggerFactory.getLogger((String)"kms-audit");

    SimpleKMSAuditLogger() {
    }

    @Override
    public void cleanup() throws IOException {
    }

    @Override
    public void initialize(Configuration conf) throws IOException {
    }

    @Override
    public void logAuditEvent(KMSAuditLogger.OpStatus status, KMSAuditLogger.AuditEvent event) {
        if (!StringUtils.isEmpty((CharSequence)event.getUser()) && !StringUtils.isEmpty((CharSequence)event.getKeyName()) && event.getOp() != null && KMSAudit.AGGREGATE_OPS_WHITELIST.contains(event.getOp())) {
            switch (status) {
                case OK: {
                    this.auditLog.info("{}[op={}, key={}, user={}, accessCount={}, interval={}ms] {}", new Object[]{status, event.getOp(), event.getKeyName(), event.getUser(), event.getAccessCount().get(), event.getEndTime() - event.getStartTime(), event.getExtraMsg()});
                    break;
                }
                case UNAUTHORIZED: {
                    this.logAuditSimpleFormat(status, event);
                    break;
                }
                default: {
                    this.logAuditSimpleFormat(status, event);
                    break;
                }
            }
        } else {
            this.logAuditSimpleFormat(status, event);
        }
    }

    private void logAuditSimpleFormat(KMSAuditLogger.OpStatus status, KMSAuditLogger.AuditEvent event) {
        LinkedList<String> kvs = new LinkedList<String>();
        if (event.getOp() != null) {
            kvs.add("op=" + event.getOp());
        }
        if (!StringUtils.isEmpty((CharSequence)event.getKeyName())) {
            kvs.add("key=" + event.getKeyName());
        }
        if (!StringUtils.isEmpty((CharSequence)event.getUser())) {
            kvs.add("user=" + event.getUser());
        }
        if (kvs.isEmpty()) {
            this.auditLog.info("{} {}", (Object)status, (Object)event.getExtraMsg());
        } else {
            String join = Joiner.on((String)", ").join(kvs);
            this.auditLog.info("{}[{}] {}", new Object[]{status, join, event.getExtraMsg()});
        }
    }
}

