/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine.perftest.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.hadoop.thirdparty.com.google.common.base.Function;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.base.Throwables;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.policyengine.RangerAccessRequestDeserializer;
import org.apache.ranger.policyengine.RangerResourceDeserializer;

public class RangerPolicyFactory {
    private static final double SUCCESSFUL_ACCESS_RATE = 0.7;
    private static final Random RANDOM = new Random();
    private static final List<String> KNOWN_DATABASES = RangerPolicyFactory.createList("database", 10);
    private static final List<String> KNOWN_TABLES = RangerPolicyFactory.createList("tables", 100);
    private static final List<String> KNOWN_COLUMNS = RangerPolicyFactory.createList("column", 1000);
    private static final List<String> KNOWN_USERS = RangerPolicyFactory.createList("user", 1000);
    private static final List<String> RANDOM_VALUES = RangerPolicyFactory.createList("random", 100);
    private static final List<String> ALWAYS_ALLOWED_ACCESS_TYPES = Arrays.asList("create", "select", "drop");

    public static ServicePolicies createServicePolicy(int numberOfPolicies) {
        ServicePolicies servicePolicies = (ServicePolicies)RangerPolicyFactory.loadTemplate("/testdata/test_servicepolicies_hive.json", new TypeToken<ServicePolicies>(){}.getType());
        RangerPolicyFactory.mutate(servicePolicies, numberOfPolicies);
        return servicePolicies;
    }

    private static void mutate(ServicePolicies servicePolicies, int numberOfPolicies) {
        servicePolicies.getPolicies().clear();
        servicePolicies.setPolicies(RangerPolicyFactory.createPolicies(numberOfPolicies));
    }

    private static List<RangerPolicy> createPolicies(int numberOfPolicies) {
        ArrayList policies = Lists.newArrayList();
        String template = RangerPolicyFactory.readResourceFile("/testdata/single-policy-template.json");
        for (int i = 0; i < numberOfPolicies; ++i) {
            policies.add(RangerPolicyFactory.createPolicyFromTemplate(template, i, RangerPolicyFactory.isAllowed()));
        }
        return policies;
    }

    private static RangerPolicy createPolicyFromTemplate(String template, long policyId, boolean isAllowed) {
        RangerPolicy rangerPolicy = (RangerPolicy)RangerPolicyFactory.buildGson().fromJson(template, RangerPolicy.class);
        rangerPolicy.setId(Long.valueOf(policyId));
        rangerPolicy.setName(String.format("generated policyname #%s", policyId));
        rangerPolicy.setResources(RangerPolicyFactory.createRangerPolicyResourceMap(isAllowed));
        rangerPolicy.setPolicyItems(RangerPolicyFactory.createPolicyItems(isAllowed));
        return rangerPolicy;
    }

    private static Map<String, RangerPolicy.RangerPolicyResource> createRangerPolicyResourceMap(boolean isAllowed) {
        RangerPolicy.RangerPolicyResource db = new RangerPolicy.RangerPolicyResource(isAllowed ? RangerPolicyFactory.pickFewRandomly(KNOWN_DATABASES) : RANDOM_VALUES, Boolean.valueOf(false), Boolean.valueOf(false));
        RangerPolicy.RangerPolicyResource table = new RangerPolicy.RangerPolicyResource(isAllowed ? RangerPolicyFactory.pickFewRandomly(KNOWN_TABLES) : RANDOM_VALUES, Boolean.valueOf(false), Boolean.valueOf(false));
        RangerPolicy.RangerPolicyResource column = new RangerPolicy.RangerPolicyResource(isAllowed ? RangerPolicyFactory.pickFewRandomly(KNOWN_COLUMNS) : RANDOM_VALUES, Boolean.valueOf(false), Boolean.valueOf(false));
        return ImmutableMap.of((Object)"database", (Object)db, (Object)"table", (Object)table, (Object)"column", (Object)column);
    }

    private static List<RangerPolicy.RangerPolicyItem> createPolicyItems(boolean isAllowed) {
        ArrayList policyItems = Lists.newArrayList();
        for (int i = 0; i < 15; ++i) {
            policyItems.add(RangerPolicyFactory.createPolicyItem(isAllowed));
        }
        return policyItems;
    }

    private static RangerPolicy.RangerPolicyItem createPolicyItem(boolean isAllowed) {
        RangerPolicy.RangerPolicyItem rangerPolicyItem = new RangerPolicy.RangerPolicyItem();
        rangerPolicyItem.setDelegateAdmin(Boolean.valueOf(false));
        rangerPolicyItem.setUsers(isAllowed ? KNOWN_USERS : RANDOM_VALUES);
        rangerPolicyItem.setAccesses(RangerPolicyFactory.createAccesses(isAllowed));
        return rangerPolicyItem;
    }

    private static List<RangerPolicy.RangerPolicyItemAccess> createAccesses(boolean isAllowed) {
        ArrayList results = Lists.newArrayList();
        results.addAll(Lists.transform(isAllowed ? ALWAYS_ALLOWED_ACCESS_TYPES : RANDOM_VALUES, (Function)new Function<String, RangerPolicy.RangerPolicyItemAccess>(){

            public RangerPolicy.RangerPolicyItemAccess apply(String input) {
                return new RangerPolicy.RangerPolicyItemAccess(input, Boolean.valueOf(true));
            }
        }));
        return results;
    }

    public static List<RangerAccessRequest> createAccessRequests(int nubmerOfRequests) {
        ArrayList result = Lists.newArrayList();
        Gson gson = RangerPolicyFactory.buildGson();
        String template = RangerPolicyFactory.readResourceFile("/testdata/single-request-template.json");
        for (int i = 0; i < nubmerOfRequests; ++i) {
            RangerAccessRequestImpl accessRequest = (RangerAccessRequestImpl)gson.fromJson(template, RangerAccessRequestImpl.class);
            result.add(RangerPolicyFactory.mutate((RangerAccessRequest)accessRequest, RangerPolicyFactory.isAllowed()));
        }
        return result;
    }

    private static boolean isAllowed() {
        return RANDOM.nextDouble() < 0.7;
    }

    private static RangerAccessRequest mutate(RangerAccessRequest template, boolean shouldEvaluateToTrue) {
        RangerAccessRequestImpl accessRequest = (RangerAccessRequestImpl)template;
        accessRequest.setResource((RangerAccessResource)new RangerAccessResourceImpl(RangerPolicyFactory.createResourceElements(shouldEvaluateToTrue)));
        accessRequest.setAccessType(RangerPolicyFactory.pickOneRandomly(ALWAYS_ALLOWED_ACCESS_TYPES));
        accessRequest.setRequestData(null);
        accessRequest.setUser(RangerPolicyFactory.pickOneRandomly(KNOWN_USERS));
        return accessRequest;
    }

    private static ImmutableMap<String, Object> createResourceElements(boolean shouldEvaluateToTrue) {
        String database = String.format("db_%s", System.nanoTime());
        String table = String.format("table_%s", System.nanoTime());
        String column = String.format("column_%s", System.nanoTime());
        if (shouldEvaluateToTrue) {
            database = RangerPolicyFactory.pickOneRandomly(KNOWN_DATABASES);
            table = RangerPolicyFactory.pickOneRandomly(KNOWN_TABLES);
            column = RangerPolicyFactory.pickOneRandomly(KNOWN_COLUMNS);
        }
        return ImmutableMap.of((Object)"database", (Object)database, (Object)"table", (Object)table, (Object)"column", (Object)column);
    }

    private static List<String> createList(String name, int n) {
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            results.add(String.format("%s_%s", name, i));
        }
        return results;
    }

    private static String pickOneRandomly(Collection<String> list) {
        return (String)Iterables.get(list, (int)RANDOM.nextInt(list.size()));
    }

    private static List<String> pickFewRandomly(List<String> list) {
        int resultSize = RANDOM.nextInt(list.size());
        HashSet results = Sets.newHashSet();
        for (int i = 0; i < resultSize; ++i) {
            results.add(RangerPolicyFactory.pickOneRandomly(list));
        }
        return ImmutableList.copyOf((Collection)results);
    }

    private static <T> T loadTemplate(String file, Type targetType) {
        try {
            Object model = RangerPolicyFactory.buildGson().fromJson(RangerPolicyFactory.readResourceFile(file), targetType);
            return (T)model;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Gson buildGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z");
        return gsonBuilder.registerTypeAdapter(RangerAccessRequest.class, (Object)new RangerAccessRequestDeserializer(gsonBuilder)).registerTypeAdapter(RangerAccessResource.class, (Object)new RangerResourceDeserializer(gsonBuilder)).setPrettyPrinting().create();
    }

    public static String readResourceFile(String fileName) {
        try {
            File f = new File(RangerPolicyFactory.class.getResource(fileName).toURI());
            Preconditions.checkState((f.exists() && f.isFile() && f.canRead() ? 1 : 0) != 0);
            return Files.toString((File)f, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static RangerPolicyEngineOptions createPolicyEngineOption() {
        RangerPolicyEngineOptions policyEngineOptions = new RangerPolicyEngineOptions();
        policyEngineOptions.disableTagPolicyEvaluation = false;
        policyEngineOptions.evaluatorType = "optimized";
        policyEngineOptions.cacheAuditResults = false;
        policyEngineOptions.disableTrieLookupPrefilter = true;
        return policyEngineOptions;
    }
}

