/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.valueextraction;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.ValueExtractor;

public abstract class OptionalExtractor {

    @UnwrapByDefault
    public static class ForDouble
    implements ValueExtractor<OptionalDouble> {
        public void extractValues(OptionalDouble originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.isPresent() ? Double.valueOf(originalValue.getAsDouble()) : null);
        }
    }

    @UnwrapByDefault
    public static class ForLong
    implements ValueExtractor<OptionalLong> {
        public void extractValues(OptionalLong originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.isPresent() ? Long.valueOf(originalValue.getAsLong()) : null);
        }
    }

    @UnwrapByDefault
    public static class ForInt
    implements ValueExtractor<OptionalInt> {
        public void extractValues(OptionalInt originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.isPresent() ? Integer.valueOf(originalValue.getAsInt()) : null);
        }
    }

    public static class ForObject
    implements ValueExtractor<Optional<?>> {
        public void extractValues(Optional<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.orElse(null));
        }
    }
}

