/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.knox;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPDPKnoxFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPDPKnoxFilter.class);
    private static final String RANGER_PLUGIN_TYPE = "knox";
    private static final String RANGER_PDP_KNOX_FILTER_IMPL_CLASSNAME = "org.apache.ranger.authorization.knox.RangerPDPKnoxFilter";
    private Filter rangerPDPKnoxFilteImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerPDPKnoxFilter() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPDPKnoxFilter.RangerPDPKnoxFilter()");
        }
        this.init0();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPDPKnoxFilter.RangerPDPKnoxFilter()");
        }
    }

    private void init0() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPDPKnoxFilter.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_PDP_KNOX_FILTER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerPDPKnoxFilteImpl = (Filter)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerKnoxPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPDPKnoxFilter.init()");
        }
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPDPKnoxFilter.destroy()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerPDPKnoxFilteImpl.destroy();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPDPKnoxFilter.destroy()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPDPKnoxFilter.doFilter()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerPDPKnoxFilteImpl.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPDPKnoxFilter.doFilter()");
        }
    }

    public void init(FilterConfig fiterConfig) throws ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPDPKnoxFilter.init()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerPDPKnoxFilteImpl.init(fiterConfig);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPDPKnoxFilter.init()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

