/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transport;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.Role;

public final class DispositionTypeDecoder
extends AbstractDescribedListTypeDecoder<Disposition> {
    private static final int MIN_DISPOSITION_LIST_ENTRIES = 2;
    private static final int MAX_DISPOSITION_LIST_ENTRIES = 6;

    @Override
    public Class<Disposition> getTypeClass() {
        return Disposition.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Disposition.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Disposition.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Disposition readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDisposition(buffer, state.getDecoder(), state, (ListTypeDecoder)DispositionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Disposition[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Disposition[] result = new Disposition[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDisposition(buffer, state.getDecoder(), state, (ListTypeDecoder)DispositionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Disposition readDisposition(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Disposition disposition = new Disposition();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 2) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 6) {
            throw new DecodeException("To many entries in Disposition list encoding: " + count);
        }
        block8: for (int index = 0; index < count; ++index) {
            if (buffer.peekByte() == 64) {
                if (index < 2) {
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    disposition.setRole(decoder.readBoolean(buffer, state, false) ? Role.RECEIVER : Role.SENDER);
                    continue block8;
                }
                case 1: {
                    disposition.setFirst(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block8;
                }
                case 2: {
                    disposition.setLast(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block8;
                }
                case 3: {
                    disposition.setSettled(decoder.readBoolean(buffer, state, false));
                    continue block8;
                }
                case 4: {
                    disposition.setState(decoder.readObject(buffer, state, DeliveryState.class));
                    continue block8;
                }
                case 5: {
                    disposition.setBatchable(decoder.readBoolean(buffer, state, false));
                }
            }
        }
        return disposition;
    }

    private String errorForMissingRequiredFields(int present) {
        switch (present) {
            case 1: {
                return "The first field cannot be omitted from the Disposition";
            }
        }
        return "The role field cannot be omitted from the Disposition";
    }

    @Override
    public Disposition readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDisposition(stream, state.getDecoder(), state, (ListTypeDecoder)DispositionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Disposition[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Disposition[] result = new Disposition[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDisposition(stream, state.getDecoder(), state, (ListTypeDecoder)DispositionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Disposition readDisposition(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Disposition disposition = new Disposition();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 2) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 6) {
            throw new DecodeException("To many entries in Disposition list encoding: " + count);
        }
        block8: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index >= 2) continue;
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    disposition.setRole(decoder.readBoolean(stream, state, false) ? Role.RECEIVER : Role.SENDER);
                    continue block8;
                }
                case 1: {
                    disposition.setFirst(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block8;
                }
                case 2: {
                    disposition.setLast(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block8;
                }
                case 3: {
                    disposition.setSettled(decoder.readBoolean(stream, state, false));
                    continue block8;
                }
                case 4: {
                    disposition.setState(decoder.readObject(stream, state, DeliveryState.class));
                    continue block8;
                }
                case 5: {
                    disposition.setBatchable(decoder.readBoolean(stream, state, false));
                }
            }
        }
        return disposition;
    }
}

