/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.crammd5.AbstractCramMd5Negotiator;
import org.apache.qpid.server.util.Strings;

public class CramMd5Base64HashedNegotiator
extends AbstractCramMd5Negotiator {
    public static final String MECHANISM = "CRAM-MD5-HASHED";
    private static final AbstractCramMd5Negotiator.PasswordTransformer BASE64_PASSWORD_TRANSFORMER = passwordData -> {
        char[] cArray;
        byte[] passwordBytes = Strings.decodeCharArray(passwordData, "CRAM MD5 hashed password");
        char[] password = new char[passwordBytes.length];
        try {
            for (int i = 0; i < passwordBytes.length; ++i) {
                password[i] = (char)passwordBytes[i];
            }
            cArray = password;
        }
        catch (Throwable throwable) {
            Strings.clearByteArray(new byte[][]{passwordBytes});
            throw throwable;
        }
        Strings.clearByteArray(new byte[][]{passwordBytes});
        return cArray;
    };

    public CramMd5Base64HashedNegotiator(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider, String localFQDN, PasswordSource passwordSource) {
        super(authenticationProvider, localFQDN, passwordSource, BASE64_PASSWORD_TRANSFORMER);
    }
}

