/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class DateTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        if (typeId.isStringTypeId() && !typeId.isLongConcatableTypeId()) {
            return true;
        }
        if (typeId.isTimestampId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == typeId.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        int n = typeId.getJDBCTypeId();
        if (n == 91 || n == 1 || n == 12) {
            return true;
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), "java.sql.Date");
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Date";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 10;
    }

    @Override
    String nullMethodName() {
        return "getNullDate";
    }
}

