/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBufAllocator;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.client.TestStatsProvider;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTester {
    static final Logger LOG = LoggerFactory.getLogger(ServerTester.class);
    private final ServerConfiguration conf;
    private final TestStatsProvider provider;
    private final Bookie bookie;
    private final BookieServer server;
    private final BookieSocketAddress address;
    private final MetadataBookieDriver metadataDriver;
    private final RegistrationManager registrationManager;
    private final LedgerManagerFactory lmFactory;
    private final LedgerManager ledgerManager;
    private final LedgerStorage storage;
    public AutoRecoveryMain autoRecovery;
    private final ByteBufAllocatorWithOomHandler allocator = BookieResources.createAllocator((ServerConfiguration)((ServerConfiguration)new ServerConfiguration().setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap)));

    public ServerTester(ServerConfiguration conf) throws Exception {
        this.conf = conf;
        this.provider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger rootStatsLogger = this.provider.getStatsLogger("");
        StatsLogger bookieStats = rootStatsLogger.scope("bookie");
        this.metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)bookieStats);
        this.registrationManager = this.metadataDriver.createRegistrationManager();
        this.lmFactory = this.metadataDriver.getLedgerManagerFactory();
        this.ledgerManager = this.lmFactory.newLedgerManager();
        LegacyCookieValidation cookieValidation = new LegacyCookieValidation(conf, this.registrationManager);
        cookieValidation.checkCookies(Main.storageDirectoriesFromConf((ServerConfiguration)conf));
        DiskChecker diskChecker = BookieResources.createDiskChecker((ServerConfiguration)conf);
        LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager((ServerConfiguration)conf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("ledger"));
        LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager((ServerConfiguration)conf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("index"), (LedgerDirsManager)ledgerDirsManager);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        this.storage = BookieResources.createLedgerStorage((ServerConfiguration)conf, (LedgerManager)this.ledgerManager, (LedgerDirsManager)ledgerDirsManager, (LedgerDirsManager)indexDirsManager, (StatsLogger)bookieStats, (ByteBufAllocator)this.allocator);
        this.bookie = conf.isForceReadOnlyBookie() ? new ReadOnlyBookie(conf, this.registrationManager, this.storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, (ByteBufAllocator)this.allocator, BookieServiceInfo.NO_INFO) : new BookieImpl(conf, this.registrationManager, this.storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, (ByteBufAllocator)this.allocator, BookieServiceInfo.NO_INFO);
        this.server = new BookieServer(conf, this.bookie, (StatsLogger)rootStatsLogger, (ByteBufAllocator)this.allocator, (UncleanShutdownDetection)uncleanShutdownDetection);
        this.address = BookieImpl.getBookieAddress((ServerConfiguration)conf);
        this.autoRecovery = null;
    }

    public ServerTester(ServerConfiguration conf, Bookie b) throws Exception {
        this.conf = conf;
        this.provider = new TestStatsProvider();
        this.metadataDriver = null;
        this.registrationManager = null;
        this.ledgerManager = null;
        this.lmFactory = null;
        this.storage = null;
        this.bookie = b;
        this.server = new BookieServer(conf, b, (StatsLogger)this.provider.getStatsLogger(""), (ByteBufAllocator)this.allocator, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        this.address = BookieImpl.getBookieAddress((ServerConfiguration)conf);
        this.autoRecovery = null;
    }

    public void startAutoRecovery() throws Exception {
        LOG.debug("Starting Auditor Recovery for the bookie: {}", (Object)this.address);
        this.autoRecovery = new AutoRecoveryMain(this.conf);
        this.autoRecovery.start();
    }

    public void stopAutoRecovery() {
        if (this.autoRecovery != null) {
            LOG.debug("Shutdown Auditor Recovery for the bookie: {}", (Object)this.address);
            this.autoRecovery.shutdown();
        }
    }

    public Auditor getAuditor() {
        if (this.autoRecovery != null) {
            return this.autoRecovery.getAuditor();
        }
        return null;
    }

    public ReplicationWorker getReplicationWorker() {
        if (this.autoRecovery != null) {
            return this.autoRecovery.getReplicationWorker();
        }
        return null;
    }

    public ServerConfiguration getConfiguration() {
        return this.conf;
    }

    public BookieServer getServer() {
        return this.server;
    }

    public TestStatsProvider getStatsProvider() {
        return this.provider;
    }

    public BookieSocketAddress getAddress() {
        return this.address;
    }

    public void shutdown() throws Exception {
        this.server.shutdown();
        if (this.ledgerManager != null) {
            this.ledgerManager.close();
        }
        if (this.lmFactory != null) {
            this.lmFactory.close();
        }
        if (this.registrationManager != null) {
            this.registrationManager.close();
        }
        if (this.metadataDriver != null) {
            this.metadataDriver.close();
        }
        if (this.autoRecovery != null) {
            LOG.debug("Shutdown auto recovery for bookieserver: {}", (Object)this.address);
            this.autoRecovery.shutdown();
        }
    }

    public static class MockUncleanShutdownDetection
    implements UncleanShutdownDetection {
        private boolean startRegistered;
        private boolean shutdownRegistered;

        public void registerStartUp() {
            this.startRegistered = true;
        }

        public void registerCleanShutdown() {
            this.shutdownRegistered = true;
        }

        public boolean lastShutdownWasUnclean() {
            return this.startRegistered && !this.shutdownRegistered;
        }

        public boolean getStartRegistered() {
            return this.startRegistered;
        }

        public boolean getShutdownRegistered() {
            return this.shutdownRegistered;
        }
    }
}

