/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannel;
import org.apache.pulsar.broker.loadbalance.extensions.manager.UnloadManager;
import org.apache.pulsar.broker.loadbalance.extensions.models.Unload;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadDecision;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.LoadManagerScheduler;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.NamespaceUnloadStrategy;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.TransferShedder;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnloadScheduler
implements LoadManagerScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnloadScheduler.class);
    private final NamespaceUnloadStrategy namespaceUnloadStrategy;
    private final ScheduledExecutorService loadManagerExecutor;
    private final PulsarService pulsar;
    private final UnloadManager unloadManager;
    private final LoadManagerContext context;
    private final ServiceUnitStateChannel channel;
    private final ServiceConfiguration conf;
    private final UnloadCounter counter;
    private final AtomicReference<List<Metrics>> unloadMetrics;
    private long counterLastUpdatedAt = 0L;
    private volatile ScheduledFuture<?> task;
    private final Set<String> unloadBrokers;
    private final Map<String, Long> recentlyUnloadedBundles;
    private final Map<String, Long> recentlyUnloadedBrokers;

    public UnloadScheduler(PulsarService pulsar, ScheduledExecutorService loadManagerExecutor, UnloadManager unloadManager, LoadManagerContext context, ServiceUnitStateChannel channel, UnloadCounter counter, AtomicReference<List<Metrics>> unloadMetrics) {
        this(pulsar, loadManagerExecutor, unloadManager, context, channel, UnloadScheduler.createNamespaceUnloadStrategy(pulsar), counter, unloadMetrics);
    }

    @VisibleForTesting
    protected UnloadScheduler(PulsarService pulsar, ScheduledExecutorService loadManagerExecutor, UnloadManager unloadManager, LoadManagerContext context, ServiceUnitStateChannel channel, NamespaceUnloadStrategy strategy, UnloadCounter counter, AtomicReference<List<Metrics>> unloadMetrics) {
        this.pulsar = pulsar;
        this.namespaceUnloadStrategy = strategy;
        this.recentlyUnloadedBundles = new HashMap<String, Long>();
        this.recentlyUnloadedBrokers = new HashMap<String, Long>();
        this.unloadBrokers = new HashSet<String>();
        this.loadManagerExecutor = loadManagerExecutor;
        this.counter = counter;
        this.unloadMetrics = unloadMetrics;
        this.unloadManager = unloadManager;
        this.context = context;
        this.conf = context.brokerConfiguration();
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void execute() {
        boolean debugMode;
        boolean bl = debugMode = this.conf.isLoadBalancerDebugModeEnabled() || log.isDebugEnabled();
        if (debugMode) {
            log.info("Load balancer enabled: {}, Shedding enabled: {}.", (Object)this.conf.isLoadBalancerEnabled(), (Object)this.conf.isLoadBalancerSheddingEnabled());
        }
        if (!this.isLoadBalancerSheddingEnabled()) {
            if (!debugMode) return;
            log.info("The load balancer or load balancer shedding already disabled. Skipping.");
            return;
        }
        long timeout = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(this.conf.getLoadBalancerSheddingGracePeriodMinutes());
        this.recentlyUnloadedBundles.keySet().removeIf(e -> this.recentlyUnloadedBundles.get(e) < timeout);
        long asyncOpTimeoutMs = this.conf.getNamespaceBundleUnloadingTimeoutMs();
        NamespaceUnloadStrategy namespaceUnloadStrategy = this.namespaceUnloadStrategy;
        synchronized (namespaceUnloadStrategy) {
            try {
                Boolean isChannelOwner = this.channel.isChannelOwnerAsync().get(asyncOpTimeoutMs, TimeUnit.MILLISECONDS);
                if (!isChannelOwner.booleanValue()) {
                    if (!debugMode) return;
                    log.info("Current broker is not channel owner. Skipping.");
                    return;
                }
                List<String> availableBrokers = this.context.brokerRegistry().getAvailableBrokersAsync().get(asyncOpTimeoutMs, TimeUnit.MILLISECONDS);
                if (debugMode) {
                    log.info("Available brokers: {}", availableBrokers);
                }
                if (availableBrokers.size() <= 1) {
                    log.info("Only 1 broker available: no load shedding will be performed. Skipping.");
                    return;
                }
                Set<UnloadDecision> decisions = this.namespaceUnloadStrategy.findBundlesForUnloading(this.context, this.recentlyUnloadedBundles, this.recentlyUnloadedBrokers);
                if (debugMode) {
                    log.info("[{}] Unload decision result: {}", (Object)this.namespaceUnloadStrategy.getClass().getSimpleName(), decisions);
                }
                if (decisions.isEmpty()) {
                    if (!debugMode) return;
                    log.info("[{}] Unload decision unloads is empty. Skipping.", (Object)this.namespaceUnloadStrategy.getClass().getSimpleName());
                    return;
                }
                ArrayList futures = new ArrayList();
                this.unloadBrokers.clear();
                decisions.forEach(decision -> {
                    if (decision.getLabel() == UnloadDecision.Label.Success) {
                        Unload unload = decision.getUnload();
                        log.info("[{}] Unloading bundle: {}", (Object)this.namespaceUnloadStrategy.getClass().getSimpleName(), (Object)unload);
                        futures.add(this.unloadManager.waitAsync(this.channel.publishUnloadEventAsync(unload), unload.serviceUnit(), (UnloadDecision)decision, asyncOpTimeoutMs, TimeUnit.MILLISECONDS).thenAccept(__ -> {
                            this.unloadBrokers.add(unload.sourceBroker());
                            this.recentlyUnloadedBundles.put(unload.serviceUnit(), System.currentTimeMillis());
                            this.recentlyUnloadedBrokers.put(unload.sourceBroker(), System.currentTimeMillis());
                        }));
                    }
                });
                ((CompletableFuture)FutureUtil.waitForAll(futures).whenComplete((__, ex) -> this.counter.updateUnloadBrokerCount(this.unloadBrokers.size()))).get(asyncOpTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex2) {
                log.error("[{}] Namespace unload has exception.", (Object)this.namespaceUnloadStrategy.getClass().getSimpleName(), (Object)ex2);
            }
            finally {
                if (this.counter.updatedAt() > this.counterLastUpdatedAt) {
                    this.unloadMetrics.set(this.counter.toMetrics(this.pulsar.getAdvertisedAddress()));
                    this.counterLastUpdatedAt = this.counter.updatedAt();
                }
            }
            return;
        }
    }

    @Override
    public void start() {
        if (this.task == null) {
            long loadSheddingInterval = TimeUnit.MINUTES.toMillis(this.conf.getLoadBalancerSheddingIntervalMinutes());
            this.task = this.loadManagerExecutor.scheduleAtFixedRate(this::execute, loadSheddingInterval, loadSheddingInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
        this.recentlyUnloadedBundles.clear();
        this.recentlyUnloadedBrokers.clear();
    }

    private static NamespaceUnloadStrategy createNamespaceUnloadStrategy(PulsarService pulsar) {
        NamespaceUnloadStrategy unloadStrategy;
        ServiceConfiguration conf = pulsar.getConfiguration();
        try {
            unloadStrategy = (NamespaceUnloadStrategy)Reflections.createInstance((String)conf.getLoadBalancerLoadSheddingStrategy(), NamespaceUnloadStrategy.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
            log.info("Created namespace unload strategy:{}", (Object)unloadStrategy.getClass().getCanonicalName());
        }
        catch (Exception e) {
            log.error("Error when trying to create namespace unload strategy: {}. Using {} instead.", new Object[]{conf.getLoadBalancerLoadSheddingStrategy(), TransferShedder.class.getCanonicalName(), e});
            unloadStrategy = new TransferShedder();
        }
        unloadStrategy.initialize(pulsar);
        return unloadStrategy;
    }

    private boolean isLoadBalancerSheddingEnabled() {
        return this.conf.isLoadBalancerEnabled() && this.conf.isLoadBalancerSheddingEnabled();
    }
}

