/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.monitoring;

import io.kubernetes.client.apimachinery.KubernetesRequestDigest;
import io.kubernetes.client.util.Strings;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleTimer;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class PrometheusInterceptor
implements Interceptor {
    static final String PREFIX = "k8s_java";
    static final Counter requests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("k8s_java_requests_total")).help("Total requests")).register();
    static final Counter codes = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("k8s_java_response_code_total")).help("Response code total")).labelNames(new String[]{"code"})).register();
    static final Histogram resourceRequestLatencyHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("k8s_java_resource_request_latency_seconds")).help("Kubernetes resource request latency (seconds)")).labelNames(new String[]{"http_response_code", "group", "version", "resource", "subresource", "api_verb", "namespace"})).register();
    static final Histogram nonResourceRequestLatencyHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("k8s_java_non_resource_request_latency_seconds")).help("Kubernetes non-resource request latency (seconds)")).labelNames(new String[]{"http_response_code", "non_resource_url_path"})).register();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        double timecost;
        Response response;
        requests.inc();
        Request request = chain.request();
        KubernetesRequestDigest requestDigest = KubernetesRequestDigest.parse(request);
        SimpleTimer timer = new SimpleTimer();
        try {
            response = chain.proceed(chain.request());
        }
        finally {
            timecost = timer.elapsedSeconds();
        }
        ((Counter.Child)codes.labels(new String[]{Integer.toString(response.code())})).inc();
        if (requestDigest.isNonResourceRequest()) {
            ((Histogram.Child)nonResourceRequestLatencyHistogram.labels(new String[]{Integer.toString(response.code()), requestDigest.getUrlPath()})).observe(timecost);
        } else {
            ((Histogram.Child)resourceRequestLatencyHistogram.labels(new String[]{Integer.toString(response.code()), Strings.nullToEmpty(requestDigest.getResourceMeta().getGroupVersionResource().getGroup()), Strings.nullToEmpty(requestDigest.getResourceMeta().getGroupVersionResource().getVersion()), Strings.nullToEmpty(requestDigest.getResourceMeta().getGroupVersionResource().getResource()), Strings.nullToEmpty(requestDigest.getResourceMeta().getSubResource()), requestDigest.getVerb().value(), Strings.nullToEmpty(requestDigest.getResourceMeta().getNamespace())})).observe(timecost);
        }
        return response;
    }
}

