/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.PluginUtil;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverFactory;
import org.apache.logging.log4j.status.StatusLogger;

public final class TemplateResolverFactories {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private TemplateResolverFactories() {
    }

    public static <V, C extends TemplateResolverContext<V, C>, F extends TemplateResolverFactory<V, C>> Map<String, F> populateFactoryByName(List<String> pluginPackages, Class<V> valueClass, Class<C> contextClass) {
        Map pluginTypeByName = PluginUtil.collectPluginsByCategoryAndPackage((String)"JsonTemplateResolverFactory", pluginPackages);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found {} plugins of category \"{}\": {}", (Object)pluginTypeByName.size(), (Object)"JsonTemplateResolverFactory", pluginTypeByName.keySet());
        }
        Map<String, F> factoryByName = TemplateResolverFactories.populateFactoryByName(pluginTypeByName, valueClass, contextClass);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("matched {} resolver factories out of {} for value class {} and context class {}: {}", (Object)factoryByName.size(), (Object)pluginTypeByName.size(), valueClass, contextClass, factoryByName.keySet());
        }
        return factoryByName;
    }

    private static <V, C extends TemplateResolverContext<V, C>, F extends TemplateResolverFactory<V, C>> Map<String, F> populateFactoryByName(Map<String, PluginType<?>> pluginTypeByName, Class<V> valueClass, Class<C> contextClass) {
        LinkedHashMap factoryByName = new LinkedHashMap();
        Set<String> pluginNames = pluginTypeByName.keySet();
        for (String pluginName : pluginNames) {
            TemplateResolverFactory<?, ?> rawFactory;
            F factory;
            PluginType<?> pluginType = pluginTypeByName.get(pluginName);
            Class pluginClass = pluginType.getPluginClass();
            boolean pluginClassMatched = TemplateResolverFactory.class.isAssignableFrom(pluginClass);
            if (!pluginClassMatched || (factory = TemplateResolverFactories.castFactory(valueClass, contextClass, rawFactory = TemplateResolverFactories.instantiateFactory(pluginName, pluginClass))) == null) continue;
            TemplateResolverFactories.addFactory(factoryByName, factory);
        }
        return factoryByName;
    }

    private static TemplateResolverFactory<?, ?> instantiateFactory(String pluginName, Class<?> pluginClass) {
        try {
            return (TemplateResolverFactory)PluginUtil.instantiatePlugin(pluginClass);
        }
        catch (Exception error) {
            String message = String.format("failed instantiating resolver factory plugin %s of name %s", pluginClass, pluginName);
            throw new RuntimeException(message, error);
        }
    }

    private static <V, C extends TemplateResolverContext<V, C>, F extends TemplateResolverFactory<V, C>> F castFactory(Class<V> valueClass, Class<C> contextClass, TemplateResolverFactory<?, ?> factory) {
        Class<?> factoryValueClass = factory.getValueClass();
        Class<?> factoryContextClass = factory.getContextClass();
        boolean factoryValueClassMatched = valueClass.isAssignableFrom(factoryValueClass);
        boolean factoryContextClassMatched = contextClass.isAssignableFrom(factoryContextClass);
        if (factoryValueClassMatched && factoryContextClassMatched) {
            TemplateResolverFactory<?, ?> typedFactory = factory;
            return (F)typedFactory;
        }
        return null;
    }

    private static <V, C extends TemplateResolverContext<V, C>, F extends TemplateResolverFactory<V, C>> void addFactory(Map<String, F> factoryByName, F factory) {
        String factoryName = factory.getName();
        TemplateResolverFactory conflictingFactory = (TemplateResolverFactory)factoryByName.putIfAbsent(factoryName, factory);
        if (conflictingFactory != null) {
            String message = String.format("found resolver factories with overlapping names: %s (%s and %s)", factoryName, conflictingFactory, factory);
            throw new IllegalArgumentException(message);
        }
    }
}

