/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.EnvelopedEntryReader;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class TestEntry {
    @Test(timeout=20000L)
    public void testEmptyRecordSet() throws Exception {
        Entry.Writer writer = Entry.newEntry((String)"test-empty-record-set", (int)1024, (boolean)true, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ByteBuf buffer = writer.getBuffer();
        EnvelopedEntryReader reader = (EnvelopedEntryReader)Entry.newBuilder().setEntry(buffer).setLogSegmentInfo(1L, 0L).setEntryId(0L).buildReader();
        int refCnt = reader.getSrcBuf().refCnt();
        Assert.assertFalse((boolean)reader.isExhausted());
        Assert.assertNull((String)"Empty record set should return null", (Object)reader.nextRecord());
        Assert.assertTrue((boolean)reader.isExhausted());
        Assert.assertEquals((long)(refCnt - 1), (long)reader.getSrcBuf().refCnt());
        Assert.assertNull((String)"Empty record set should return null", (Object)reader.nextRecord());
        Assert.assertEquals((long)(refCnt - 1), (long)reader.getSrcBuf().refCnt());
        ReferenceCountUtil.release((Object)buffer);
    }

    @Test(timeout=20000L)
    public void testWriteTooLongRecord() throws Exception {
        Entry.Writer writer = Entry.newEntry((String)"test-write-too-long-record", (int)1024, (boolean)true, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        LogRecord largeRecord = new LogRecord(1L, new byte[1040385]);
        try {
            writer.writeRecord(largeRecord, new CompletableFuture());
            Assert.fail((String)"Should fail on writing large record");
        }
        catch (LogRecordTooLongException logRecordTooLongException) {
            // empty catch block
        }
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ByteBuf buffer = writer.getBuffer();
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)buffer.readableBytes());
        ReferenceCountUtil.release((Object)buffer);
    }

    @Test(timeout=20000L)
    public void testWriteRecords() throws Exception {
        Entry.Writer writer = Entry.newEntry((String)"test-write-records", (int)1024, (boolean)true, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ArrayList writePromiseList = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            LogRecord record = new LogRecord((long)i, ("record-" + i).getBytes(StandardCharsets.UTF_8));
            record.setPositionWithinLogSegment(i);
            CompletableFuture writePromise = new CompletableFuture();
            writer.writeRecord(record, writePromise);
            writePromiseList.add(writePromise);
            Assert.assertEquals((String)(i + 1 + " records"), (long)(i + 1), (long)writer.getNumRecords());
        }
        LogRecord largeRecord = new LogRecord(1L, new byte[1040385]);
        try {
            writer.writeRecord(largeRecord, new CompletableFuture());
            Assert.fail((String)"Should fail on writing large record");
        }
        catch (LogRecordTooLongException record) {
            // empty catch block
        }
        Assert.assertEquals((String)"5 records", (long)5L, (long)writer.getNumRecords());
        for (int i = 0; i < 5; ++i) {
            LogRecord record = new LogRecord((long)(i + 5), ("record-" + (i + 5)).getBytes(StandardCharsets.UTF_8));
            record.setPositionWithinLogSegment(i + 5);
            CompletableFuture writePromise = new CompletableFuture();
            writer.writeRecord(record, writePromise);
            writePromiseList.add(writePromise);
            Assert.assertEquals((String)(i + 6 + " records"), (long)(i + 6), (long)writer.getNumRecords());
        }
        ByteBuf buffer = writer.getBuffer();
        buffer.retain();
        writer.completeTransmit(1L, 1L);
        List writeResults = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)writePromiseList));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, (long)i), writeResults.get(i));
        }
        Entry.Reader reader = Entry.newBuilder().setEntry(buffer).setLogSegmentInfo(1L, 1L).setEntryId(0L).setEnvelopeEntry(true).buildReader();
        ReferenceCountUtil.release((Object)buffer);
        LogRecordWithDLSN record = reader.nextRecord();
        int numReads = 0;
        long expectedTxid = 0L;
        while (null != record) {
            Assert.assertEquals((long)expectedTxid, (long)record.getTransactionId());
            Assert.assertEquals((long)expectedTxid, (long)record.getSequenceId());
            Assert.assertEquals((Object)new DLSN(1L, 0L, expectedTxid), (Object)record.getDlsn());
            ++numReads;
            ++expectedTxid;
            record = reader.nextRecord();
        }
        Assert.assertEquals((long)10L, (long)numReads);
        reader.release();
    }

    @Test(timeout=20000L)
    public void testWriteRecordSet() throws Exception {
        int i;
        CompletableFuture writePromise;
        Entry.Writer writer = Entry.newEntry((String)"test-write-recordset", (int)1024, (boolean)true, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero bytes", (long)13L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ArrayList writePromiseList = Lists.newArrayList();
        for (int i2 = 0; i2 < 5; ++i2) {
            LogRecord record = new LogRecord((long)i2, ("record-" + i2).getBytes(StandardCharsets.UTF_8));
            record.setPositionWithinLogSegment(i2);
            CompletableFuture writePromise2 = new CompletableFuture();
            writer.writeRecord(record, writePromise2);
            writePromiseList.add(writePromise2);
            Assert.assertEquals((String)(i2 + 1 + " records"), (long)(i2 + 1), (long)writer.getNumRecords());
        }
        final LogRecordSet.Writer recordSetWriter = LogRecordSet.newWriter((int)1024, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        ArrayList recordSetPromiseList = Lists.newArrayList();
        for (int i3 = 0; i3 < 5; ++i3) {
            ByteBuffer record = ByteBuffer.wrap(("record-" + (i3 + 5)).getBytes(StandardCharsets.UTF_8));
            writePromise = new CompletableFuture();
            recordSetWriter.writeRecord(record, writePromise);
            recordSetPromiseList.add(writePromise);
            Assert.assertEquals((String)(i3 + 1 + " records"), (long)(i3 + 1), (long)recordSetWriter.getNumRecords());
        }
        ByteBuf recordSetBuffer = recordSetWriter.getBuffer();
        LogRecord setRecord = new LogRecord(5L, recordSetBuffer);
        setRecord.setPositionWithinLogSegment(5);
        setRecord.setRecordSet();
        writePromise = new CompletableFuture();
        writePromise.whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

            public void onSuccess(DLSN dlsn) {
                recordSetWriter.completeTransmit(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), dlsn.getSlotId());
            }

            public void onFailure(Throwable cause) {
                recordSetWriter.abortTransmit(cause);
            }
        });
        writer.writeRecord(setRecord, writePromise);
        writePromiseList.add(writePromise);
        for (int i4 = 0; i4 < 5; ++i4) {
            LogRecord record = new LogRecord((long)(i4 + 10), ("record-" + (i4 + 10)).getBytes(StandardCharsets.UTF_8));
            record.setPositionWithinLogSegment(i4 + 10);
            writePromise = new CompletableFuture();
            writer.writeRecord(record, writePromise);
            writePromiseList.add(writePromise);
            Assert.assertEquals((String)(i4 + 11 + " records"), (long)(i4 + 11), (long)writer.getNumRecords());
        }
        ByteBuf buffer = writer.getBuffer();
        buffer.retain();
        writer.completeTransmit(1L, 1L);
        List writeResults = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)writePromiseList));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, (long)i), writeResults.get(i));
        }
        Assert.assertEquals((Object)new DLSN(1L, 1L, 5L), writeResults.get(5));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, (long)(10 + i)), writeResults.get(6 + i));
        }
        List recordSetWriteResults = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)recordSetPromiseList));
        for (int i5 = 0; i5 < 5; ++i5) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, (long)(5 + i5)), recordSetWriteResults.get(i5));
        }
        this.verifyReadResult(buffer, 1L, 1L, 1L, true, new DLSN(1L, 1L, 2L), 3, 5, 5, new DLSN(1L, 1L, 2L), 2L);
        this.verifyReadResult(buffer, 1L, 1L, 1L, true, new DLSN(1L, 1L, 7L), 0, 3, 5, new DLSN(1L, 1L, 7L), 7L);
        this.verifyReadResult(buffer, 1L, 1L, 1L, true, new DLSN(1L, 1L, 12L), 0, 0, 3, new DLSN(1L, 1L, 12L), 12L);
        this.verifyReadResult(buffer, 1L, 1L, 1L, false, new DLSN(1L, 1L, 2L), 3, 5, 5, new DLSN(1L, 1L, 2L), 2L);
        this.verifyReadResult(buffer, 1L, 1L, 1L, false, new DLSN(1L, 1L, 7L), 0, 3, 5, new DLSN(1L, 1L, 7L), 7L);
        this.verifyReadResult(buffer, 1L, 1L, 1L, false, new DLSN(1L, 1L, 12L), 0, 0, 3, new DLSN(1L, 1L, 12L), 12L);
        ReferenceCountUtil.release((Object)buffer);
    }

    void verifyReadResult(ByteBuf data, long lssn, long entryId, long startSequenceId, boolean deserializeRecordSet, DLSN skipTo, int firstNumRecords, int secondNumRecords, int lastNumRecords, DLSN expectedDLSN, long expectedTxId) throws Exception {
        LogRecordWithDLSN record;
        Entry.Reader reader = Entry.newBuilder().setEntry(data).setLogSegmentInfo(lssn, startSequenceId).setEntryId(entryId).deserializeRecordSet(deserializeRecordSet).buildReader();
        reader.skipTo(skipTo);
        for (int i = 0; i < firstNumRecords; ++i) {
            record = reader.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((Object)expectedDLSN, (Object)record.getDlsn());
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            Assert.assertNotNull((String)("record " + record + " payload is null"), (Object)record.getPayloadBuf());
            Assert.assertEquals((Object)("record-" + expectedTxId), (Object)new String(record.getPayload(), StandardCharsets.UTF_8));
            expectedDLSN = expectedDLSN.getNextDLSN();
            ++expectedTxId;
        }
        boolean verifyDeserializedRecords = true;
        if (firstNumRecords > 0) {
            verifyDeserializedRecords = deserializeRecordSet;
        }
        if (verifyDeserializedRecords) {
            long txIdOfRecordSet = 5L;
            for (int i = 0; i < secondNumRecords; ++i) {
                record = reader.nextRecord();
                Assert.assertNotNull((Object)record);
                Assert.assertEquals((Object)expectedDLSN, (Object)record.getDlsn());
                Assert.assertEquals((long)txIdOfRecordSet, (long)record.getTransactionId());
                Assert.assertNotNull((String)("record " + record + " payload is null"), (Object)record.getPayload());
                Assert.assertEquals((Object)("record-" + expectedTxId), (Object)new String(record.getPayload(), StandardCharsets.UTF_8));
                expectedDLSN = expectedDLSN.getNextDLSN();
                ++expectedTxId;
            }
        } else {
            record = reader.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((Object)expectedDLSN, (Object)record.getDlsn());
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            for (int i = 0; i < secondNumRecords; ++i) {
                expectedDLSN = expectedDLSN.getNextDLSN();
                ++expectedTxId;
            }
        }
        for (int i = 0; i < lastNumRecords; ++i) {
            record = reader.nextRecord();
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((Object)expectedDLSN, (Object)record.getDlsn());
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            Assert.assertNotNull((String)("record " + record + " payload is null"), (Object)record.getPayload());
            Assert.assertEquals((Object)("record-" + expectedTxId), (Object)new String(record.getPayload(), StandardCharsets.UTF_8));
            expectedDLSN = expectedDLSN.getNextDLSN();
            ++expectedTxId;
        }
    }
}

