/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCommitWatcher<BUFFER> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommitWatcher.class);
    private final SortedMap<Long, List<BUFFER>> commitIndexMap = new ConcurrentSkipListMap<Long, List<BUFFER>>();
    private final ConcurrentMap<Long, CompletableFuture<XceiverClientReply>> replies = new ConcurrentHashMap<Long, CompletableFuture<XceiverClientReply>>();
    private final XceiverClientSpi client;
    private final AtomicLong totalAckDataLength = new AtomicLong();

    AbstractCommitWatcher(XceiverClientSpi client) {
        this.client = client;
    }

    @VisibleForTesting
    SortedMap<Long, List<BUFFER>> getCommitIndexMap() {
        return this.commitIndexMap;
    }

    synchronized void updateCommitInfoMap(long index, List<BUFFER> buffers) {
        this.commitIndexMap.computeIfAbsent(index, k -> new LinkedList()).addAll(buffers);
    }

    long getTotalAckDataLength() {
        return this.totalAckDataLength.get();
    }

    long addAckDataLength(long acked) {
        return this.totalAckDataLength.addAndGet(acked);
    }

    XceiverClientReply watchOnFirstIndex() throws IOException {
        if (this.commitIndexMap.isEmpty()) {
            return null;
        }
        return this.watchForCommit(this.commitIndexMap.firstKey());
    }

    XceiverClientReply watchOnLastIndex() throws IOException {
        if (this.commitIndexMap.isEmpty()) {
            return null;
        }
        return this.watchForCommit(this.commitIndexMap.lastKey());
    }

    CompletableFuture<XceiverClientReply> watchForCommitAsync(long commitIndex) {
        MemoizedSupplier supplier = JavaUtils.memoize(CompletableFuture::new);
        CompletableFuture f = this.replies.compute(commitIndex, (key, value) -> value != null ? value : (CompletableFuture)supplier.get());
        if (!supplier.isInitialized()) {
            return f;
        }
        return this.client.watchForCommit(commitIndex).thenApply(reply -> {
            f.complete(reply);
            CompletableFuture removed = (CompletableFuture)this.replies.remove(commitIndex);
            Preconditions.checkState((removed == f ? 1 : 0) != 0);
            long index = reply != null ? reply.getLogIndex() : 0L;
            this.adjustBuffers(index);
            return reply;
        });
    }

    XceiverClientReply watchForCommit(long commitIndex) throws IOException {
        try {
            return this.watchForCommitAsync(commitIndex).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.getIOExceptionForWatchForCommit(commitIndex, e);
        }
        catch (ExecutionException e) {
            throw this.getIOExceptionForWatchForCommit(commitIndex, e);
        }
    }

    List<BUFFER> remove(long i) {
        List buffers = (List)this.commitIndexMap.remove(i);
        Objects.requireNonNull(buffers, () -> "commitIndexMap.remove(" + i + ")");
        return buffers;
    }

    abstract void releaseBuffers(long var1);

    synchronized void adjustBuffers(long commitIndex) {
        this.commitIndexMap.keySet().stream().filter(p -> p <= commitIndex).forEach(this::releaseBuffers);
    }

    void releaseBuffersOnException() {
        this.adjustBuffers(this.client.getReplicatedMinCommitIndex());
    }

    IOException getIOExceptionForWatchForCommit(long commitIndex, Exception e) {
        LOG.warn("watchForCommit failed for index {}", (Object)commitIndex, (Object)e);
        IOException ioException = new IOException("Unexpected Storage Container Exception: " + e, e);
        this.releaseBuffersOnException();
        return ioException;
    }

    void cleanup() {
        this.commitIndexMap.clear();
        this.replies.clear();
    }
}

