/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.util.function.BiConsumer;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;

public class ManagedLogger
extends Logger {
    private final UncheckedAutoCloseable leakTracker = ManagedRocksObjectUtils.track((AutoCloseable)((Object)this));
    private final BiConsumer<InfoLogLevel, String> delegate;

    public ManagedLogger(ManagedDBOptions dbOptions, BiConsumer<InfoLogLevel, String> delegate) {
        super((DBOptions)dbOptions);
        this.delegate = delegate;
    }

    protected void log(InfoLogLevel infoLogLevel, String logMsg) {
        this.delegate.accept(infoLogLevel, logMsg);
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.leakTracker.close();
        }
    }
}

