/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.propagation;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerObjectFactory;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Codec;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.Binary;

public class BinaryCodec
implements Codec<Binary> {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final JaegerObjectFactory objectFactory;

    public BinaryCodec() {
        this(BinaryCodec.builder());
    }

    private BinaryCodec(Builder builder) {
        this.objectFactory = builder.objectFactory;
    }

    private static void writeLong(ByteArrayOutputStream stream, long value) {
        stream.write((byte)(value >> 56));
        stream.write((byte)(value >> 48));
        stream.write((byte)(value >> 40));
        stream.write((byte)(value >> 32));
        stream.write((byte)(value >> 24));
        stream.write((byte)(value >> 16));
        stream.write((byte)(value >> 8));
        stream.write((byte)value);
    }

    private static void writeInt(ByteArrayOutputStream stream, int value) {
        stream.write((byte)(value >> 24));
        stream.write((byte)(value >> 16));
        stream.write((byte)(value >> 8));
        stream.write((byte)value);
    }

    private void writeKvPair(ByteArrayOutputStream stream, String key, String value) {
        byte[] buf = key.getBytes(DEFAULT_CHARSET);
        int keyLen = buf.length;
        BinaryCodec.writeInt(stream, keyLen);
        stream.write(buf, 0, keyLen);
        buf = value.getBytes(DEFAULT_CHARSET);
        int valLen = value.length();
        BinaryCodec.writeInt(stream, valLen);
        stream.write(buf, 0, valLen);
    }

    private static byte[] checkBuf(int len, byte[] bytes) {
        return len <= bytes.length ? bytes : new byte[len];
    }

    @Override
    public void inject(JaegerSpanContext spanContext, Binary carrier) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(64);
        BinaryCodec.writeLong(stream, spanContext.getTraceIdHigh());
        BinaryCodec.writeLong(stream, spanContext.getTraceIdLow());
        BinaryCodec.writeLong(stream, spanContext.getSpanId());
        BinaryCodec.writeLong(stream, spanContext.getParentId());
        stream.write(spanContext.getFlags());
        BinaryCodec.writeInt(stream, spanContext.baggageCount());
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            this.writeKvPair(stream, entry.getKey(), entry.getValue());
        }
        int size = stream.size();
        ByteBuffer buf = carrier.injectionBuffer(size);
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Carrier byte order must be big endian.");
        }
        buf.put(stream.toByteArray(), 0, size);
    }

    @Override
    public JaegerSpanContext extract(Binary carrier) {
        HashMap<String, String> baggage = null;
        ByteBuffer buf = carrier.extractionBuffer();
        buf.rewind();
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Carrier byte order must be big endian.");
        }
        long traceIdHigh = buf.getLong();
        long traceIdLow = buf.getLong();
        long spanId = buf.getLong();
        long parentId = buf.getLong();
        byte flags = buf.get();
        int count = buf.getInt();
        if (count > 0) {
            baggage = new HashMap<String, String>(count);
            byte[] tmp = new byte[32];
            for (int i = 0; i < count; ++i) {
                int len = buf.getInt();
                tmp = BinaryCodec.checkBuf(len, tmp);
                buf.get(tmp, 0, len);
                String key = new String(tmp, 0, len, DEFAULT_CHARSET);
                len = buf.getInt();
                tmp = BinaryCodec.checkBuf(len, tmp);
                buf.get(tmp, 0, len);
                String value = new String(tmp, 0, len, DEFAULT_CHARSET);
                baggage.put(key, value);
            }
        }
        return this.objectFactory.createSpanContext(traceIdHigh, traceIdLow, spanId, parentId, flags, baggage, null);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BinaryCodec{").append("ObjectFactory=" + this.objectFactory.getClass().getName()).append('}');
        return buffer.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JaegerObjectFactory objectFactory = new JaegerObjectFactory();

        public Builder withObjectFactory(JaegerObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public BinaryCodec build() {
            return new BinaryCodec(this);
        }
    }
}

