/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.grpc.stub;

import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.ozone.shaded.io.grpc.CallOptions;
import org.apache.hadoop.ozone.shaded.io.grpc.Channel;
import org.apache.hadoop.ozone.shaded.io.grpc.stub.AbstractStub;
import org.apache.hadoop.ozone.shaded.io.grpc.stub.ClientCalls;

@CheckReturnValue
@ThreadSafe
public abstract class AbstractAsyncStub<S extends AbstractAsyncStub<S>>
extends AbstractStub<S> {
    protected AbstractAsyncStub(Channel channel, CallOptions callOptions) {
        super(channel, callOptions);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory2, Channel channel) {
        return AbstractAsyncStub.newStub(factory2, channel, CallOptions.DEFAULT);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory2, Channel channel, CallOptions callOptions) {
        T stub = factory2.newStub(channel, callOptions.withOption(ClientCalls.STUB_TYPE_OPTION, ClientCalls.StubType.ASYNC));
        assert (stub instanceof AbstractAsyncStub) : String.format("Expected AbstractAsyncStub, but got %s.", stub.getClass());
        return stub;
    }
}

