/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.HadoopRpcOMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.shaded.com.google.protobuf.ServiceException;

public class Hadoop3OmTransport
implements OmTransport {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final HadoopRpcOMFailoverProxyProvider omFailoverProxyProvider;
    private final OzoneManagerProtocolPB rpcProxy;

    public Hadoop3OmTransport(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of(conf), OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.omFailoverProxyProvider = new HadoopRpcOMFailoverProxyProvider<OzoneManagerProtocolPB>(conf, ugi, omServiceId, OzoneManagerProtocolPB.class);
        int maxFailovers = conf.getInt("ozone.client.failover.max.attempts", 500);
        this.rpcProxy = this.createRetryProxy(this.omFailoverProxyProvider, maxFailovers);
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest payload) throws IOException {
        try {
            OzoneManagerProtocolProtos.OMResponse omResponse = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, payload);
            if (omResponse.hasLeaderOMNodeId() && this.omFailoverProxyProvider != null) {
                String leaderOmId = omResponse.getLeaderOMNodeId();
                this.omFailoverProxyProvider.setNextOmProxy(leaderOmId);
                this.omFailoverProxyProvider.performFailover(null);
            }
            return omResponse;
        }
        catch (ServiceException e) {
            OMNotLeaderException notLeaderException = HadoopRpcOMFailoverProxyProvider.getNotLeaderException(e);
            if (notLeaderException == null) {
                throw ProtobufHelper.getRemoteException((ServiceException)e);
            }
            throw new IOException("Could not determine or connect to OM Leader.");
        }
    }

    @Override
    public Text getDelegationTokenService() {
        return this.omFailoverProxyProvider.getCurrentProxyDelegationToken();
    }

    private OzoneManagerProtocolPB createRetryProxy(HadoopRpcOMFailoverProxyProvider failoverProxyProvider, int maxFailovers) {
        OzoneManagerProtocolPB proxy = (OzoneManagerProtocolPB)RetryProxy.create(OzoneManagerProtocolPB.class, (FailoverProxyProvider)failoverProxyProvider, (RetryPolicy)failoverProxyProvider.getRetryPolicy(maxFailovers));
        return proxy;
    }

    @VisibleForTesting
    public HadoopRpcOMFailoverProxyProvider getOmFailoverProxyProvider() {
        return this.omFailoverProxyProvider;
    }

    @Override
    public void close() throws IOException {
        this.omFailoverProxyProvider.close();
    }
}

